/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.block.sign.AbstractFramedHangingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallHangingSignBlock
extends AbstractFramedHangingSignBlock {
    public FramedWallHangingSignBlock() {
        super(BlockType.FRAMED_WALL_HANGING_SIGN, IFramedBlock.createProperties(BlockType.FRAMED_WALL_HANGING_SIGN).m_60910_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction dir : ctx.m_6232_()) {
            if (!dir.m_122434_().m_122479_() || dir.m_122434_().test(ctx.m_43719_()) || !(state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_())).m_60710_((LevelReader)level, pos) || !FramedWallHangingSignBlock.canPlace(state, (LevelReader)level, pos)) continue;
            return FramedWallHangingSignBlock.withWater(state, (LevelReader)level, pos);
        }
        return null;
    }

    @Override
    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedSignBlockEntity) {
            FramedSignBlockEntity sign = (FramedSignBlockEntity)blockEntity;
            boolean front = sign.isFacingFrontText(player);
            ItemStack stack = player.m_21120_(hand);
            if (!sign.canExecuteCommands(front, player) && stack.m_41720_() == this.m_5456_()) {
                return hit.m_82434_().m_122434_() == ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122434_();
            }
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)) {
            case Direction.NORTH, Direction.SOUTH -> WallHangingSignBlock.f_244474_;
            case Direction.EAST, Direction.WEST -> WallHangingSignBlock.f_243914_;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.m_5940_(state, level, pos, CollisionContext.m_82749_());
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)) {
            case Direction.NORTH, Direction.SOUTH -> WallHangingSignBlock.f_244007_;
            case Direction.EAST, Direction.WEST -> WallHangingSignBlock.f_244065_;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)));
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    public static boolean canPlace(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction dirCw = dir.m_122427_();
        Direction dirCcw = dir.m_122428_();
        return FramedWallHangingSignBlock.canAttachTo(level, state, pos.m_121945_(dirCw), dirCcw) || FramedWallHangingSignBlock.canAttachTo(level, state, pos.m_121945_(dirCcw), dirCw);
    }

    private static boolean canAttachTo(LevelReader level, BlockState state, BlockPos pos, Direction side) {
        BlockState adjState = level.m_8055_(pos);
        if (adjState.m_60734_() instanceof FramedWallHangingSignBlock) {
            return ((Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR)).m_122434_().test((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR));
        }
        return adjState.m_60659_((BlockGetter)level, pos, side, SupportType.FULL);
    }
}

