/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallSignBlock
extends AbstractFramedSignBlock {
    private static final Vec3[] HITBOX_CENTERS = (Vec3[])Util.m_137469_((Object)new Vec3[4], arr -> {
        arr[Direction.NORTH.m_122416_()] = new Vec3(0.5, 0.5, 0.9375);
        arr[Direction.EAST.m_122416_()] = new Vec3(0.0625, 0.5, 0.5);
        arr[Direction.SOUTH.m_122416_()] = new Vec3(0.5, 0.5, 0.0625);
        arr[Direction.WEST.m_122416_()] = new Vec3(0.9375, 0.5, 0.5);
    });

    public FramedWallSignBlock() {
        super(BlockType.FRAMED_WALL_SIGN, IFramedBlock.createProperties(BlockType.FRAMED_WALL_SIGN).m_60910_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] dirs;
        BlockState state = this.m_49966_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction direction : dirs = context.m_6232_()) {
            Direction dir;
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)(dir = direction.m_122424_()))).m_60710_((LevelReader)level, pos)) continue;
            return FramedWallSignBlock.withWater(state, (LevelReader)level, pos);
        }
        return null;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (dir.m_122424_() == state.m_61143_((Property)FramedProperties.FACING_HOR) && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, dir, facingState, level, pos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122424_();
        return level.m_8055_(pos.m_121945_(dir)).m_280296_();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122435_();
    }

    @Override
    public Vec3 getSignHitboxCenterPosition(BlockState state) {
        return HITBOX_CENTERS[((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)).m_122416_()];
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            switch ((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR)) {
                case NORTH: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.m_49796_((double)0.0, (double)4.5, (double)14.0, (double)16.0, (double)12.5, (double)16.0));
                    break;
                }
                case EAST: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.m_49796_((double)0.0, (double)4.5, (double)0.0, (double)2.0, (double)12.5, (double)16.0));
                    break;
                }
                case SOUTH: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.m_49796_((double)0.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)2.0));
                    break;
                }
                case WEST: {
                    builder.put((Object)state, (Object)FramedWallSignBlock.m_49796_((double)14.0, (double)4.5, (double)0.0, (double)16.0, (double)12.5, (double)16.0));
                }
            }
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

