/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDividedSlopeBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedDividedSlopeBlock
extends AbstractFramedDoubleBlock
implements ISlopeBlock {
    public FramedDividedSlopeBlock() {
        super(BlockType.FRAMED_DIVIDED_SLOPE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.SLOPE_TYPE, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedDividedSlopeBlock.withSlopeType(this.m_49966_(), context.m_43719_(), context.m_8125_(), context.m_43720_());
        return FramedDividedSlopeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (Utils.isY(face) || type != SlopeType.HORIZONTAL && face == dir.m_122424_()) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        if (rot != Rotation.NONE && face == dir) {
            return (BlockState)state.m_61122_(PropertyHolder.SLOPE_TYPE);
        }
        return state;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return Utils.mirrorCornerBlock(state, mirror);
        }
        return Utils.mirrorFaceBlock(state, mirror);
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
    }

    @Override
    public SlopeType getSlopeType(BlockState state) {
        return (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (type == SlopeType.HORIZONTAL) {
            BlockState defState = ((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.get()).m_49966_();
            return new Tuple((Object)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))), (Object)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(true))));
        }
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.get()).m_49966_();
        boolean top = type == SlopeType.TOP;
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)PropertyHolder.RIGHT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        boolean horizontal = state.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL;
        return horizontal ? DoubleBlockTopInteractionMode.SECOND : DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        if (type == SlopeType.HORIZONTAL) {
            if (side == Direction.UP) {
                return CamoGetter.SECOND;
            }
            if (side == Direction.DOWN) {
                return CamoGetter.FIRST;
            }
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (side == facing || side == facing.m_122428_()) {
                if (edge == Direction.UP) {
                    return CamoGetter.SECOND;
                }
                if (edge == Direction.DOWN) {
                    return CamoGetter.FIRST;
                }
            }
        } else {
            Direction dirTwo;
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (side == facing.m_122427_()) {
                return CamoGetter.SECOND;
            }
            if (side == facing.m_122428_()) {
                return CamoGetter.FIRST;
            }
            Direction direction = dirTwo = type == SlopeType.TOP ? Direction.UP : Direction.DOWN;
            if (side == facing || side == dirTwo) {
                if (edge == facing.m_122427_()) {
                    return CamoGetter.SECOND;
                }
                if (edge == facing.m_122428_()) {
                    return CamoGetter.FIRST;
                }
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction secDir;
        SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = secDir = facing.m_122428_();
            }
        }
        if (side == facing || side == secDir) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedDividedSlopeBlockEntity(pos, state);
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_DIVIDED_SLOPE.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

