/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanelcorner.FramedCornerSlopePanelBlock;
import xfacthd.framedblocks.common.blockentity.doubled.FramedExtendedDoubleCornerSlopePanelBlockEntity;
import xfacthd.framedblocks.common.blockentity.doubled.FramedExtendedInnerDoubleCornerSlopePanelBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;
import xfacthd.framedblocks.common.util.DoubleBlockTopInteractionMode;

public class FramedExtendedDoubleCornerSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public FramedExtendedDoubleCornerSlopePanelBlock(BlockType blockType) {
        super(blockType);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelBlock.getStateForPlacement(this.m_49966_(), ctx, this.getBlockType() == BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, true);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return (BlockState)state.m_61122_((Property)FramedProperties.TOP);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> new FramedExtendedDoubleCornerSlopePanelBlockEntity(pos, state);
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> new FramedExtendedInnerDoubleCornerSlopePanelBlockEntity(pos, state);
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        boolean ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> new Tuple((Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir)).m_61124_((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(!top))).m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
            default -> throw new IllegalArgumentException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
        return top ? DoubleBlockTopInteractionMode.FIRST : DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> {
                Direction dirTwo;
                Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
                Direction v0 = dirTwo = top ? Direction.UP : Direction.DOWN;
                if (side == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing.m_122424_() || side == facing.m_122427_()) {
                    yield CamoGetter.SECOND;
                }
                if (side == facing) {
                    if (edge == facing.m_122428_() || edge == dirTwo) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.m_122427_()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == facing.m_122428_()) {
                    if (edge == facing || edge == dirTwo) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.m_122424_()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == dirTwo.m_122424_() && (edge == facing.m_122427_() || edge == facing.m_122424_())) {
                    yield CamoGetter.SECOND;
                }
                yield CamoGetter.NONE;
            }
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> {
                Direction dirTwo;
                Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
                Direction v2 = dirTwo = top ? Direction.UP : Direction.DOWN;
                if (side == facing.m_122424_() || side == facing.m_122427_() || side == dirTwo) {
                    yield CamoGetter.FIRST;
                }
                if (side == dirTwo.m_122424_() && (edge == facing.m_122424_() || edge == facing.m_122427_())) {
                    yield CamoGetter.FIRST;
                }
                if (side == facing) {
                    if (edge == dirTwo || edge == facing.m_122427_()) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing.m_122428_()) {
                        yield CamoGetter.SECOND;
                    }
                } else if (side == facing.m_122428_()) {
                    if (edge == dirTwo || edge == facing.m_122424_()) {
                        yield CamoGetter.FIRST;
                    }
                    if (edge == facing) {
                        yield CamoGetter.SECOND;
                    }
                }
                yield CamoGetter.NONE;
            }
            default -> throw new IllegalArgumentException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        return switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> {
                boolean top;
                if (Utils.isY(side) && ((top = ((Boolean)state.m_61143_((Property)FramedProperties.TOP)).booleanValue()) ? side == Direction.UP : side == Direction.DOWN)) {
                    yield SolidityCheck.FIRST;
                }
                Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                if (side == facing.m_122424_() || side == facing.m_122427_()) {
                    yield SolidityCheck.SECOND;
                }
                yield SolidityCheck.BOTH;
            }
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> {
                boolean primaryYFace = false;
                if (Utils.isY(side)) {
                    boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
                    primaryYFace = top ? side == Direction.UP : side == Direction.DOWN;
                }
                Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
                if (primaryYFace || side == facing.m_122424_() || side == facing.m_122427_()) {
                    yield SolidityCheck.FIRST;
                }
                yield SolidityCheck.BOTH;
            }
            default -> throw new IllegalArgumentException("Unexpected type: " + this.getBlockType());
        };
    }

    @Override
    public BlockItem createBlockItem() {
        Block other = switch ((BlockType)this.getBlockType()) {
            case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL_WALL.get();
            case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL_WALL.get();
            default -> throw new IllegalStateException("Unexpected type: " + this.getBlockType());
        };
        return new VerticalAndWallBlockItem(this, other, new Item.Properties());
    }

    public static BlockState itemModelSource() {
        return ((Block)FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL.get()).m_49966_();
    }

    public static BlockState itemModelSourceInner() {
        return (BlockState)((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL.get()).m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)Direction.EAST);
    }
}

