/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;

public final class FramedSignBlockEntity
extends FramedBlockEntity {
    @Nullable
    private UUID editingPlayer;
    private SignText frontText = new SignText();
    private SignText backText = new SignText();
    private boolean waxed;
    private AABB renderBounds;

    private FramedSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.renderBounds = state.m_60808_((BlockGetter)EmptyBlockGetter.INSTANCE, pos).m_83215_().m_82338_(pos);
    }

    public boolean isFacingFrontText(Player player) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractFramedSignBlock) {
            float playerAngle;
            AbstractFramedSignBlock signblock = (AbstractFramedSignBlock)block;
            Vec3 center = signblock.getSignHitboxCenterPosition(this.m_58900_());
            double dX = player.m_20185_() - ((double)this.m_58899_().m_123341_() + center.f_82479_);
            double dY = player.m_20189_() - ((double)this.m_58899_().m_123343_() + center.f_82481_);
            float blockAngle = signblock.getYRotationDegrees(this.m_58900_());
            return Mth.m_14145_((float)blockAngle, (float)(playerAngle = (float)(Mth.m_14136_((double)dY, (double)dX) * 57.2957763671875) - 90.0f)) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean front) {
        return front ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public void updateTextFromPacket(Player player, boolean front, List<FilteredText> filteredText) {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.isWaxed() || !player.m_20148_().equals(this.editingPlayer)) {
            FramedBlocks.LOGGER.warn("Player {} just tried to change non-editable sign at", (Object)player.m_7755_().getString(), (Object)this.f_58858_);
            return;
        }
        this.updateText(text -> {
            boolean filter = player.m_143387_();
            for (int idx = 0; idx < filteredText.size(); ++idx) {
                FilteredText filteredtext = (FilteredText)filteredText.get(idx);
                Style style = text.m_277138_(idx, filter).m_7383_();
                MutableComponent filteredLine = Component.m_237113_((String)filteredtext.m_243113_()).m_6270_(style);
                MutableComponent line = filter ? filteredLine : Component.m_237113_((String)filteredtext.f_215168_()).m_6270_(style);
                text = text.m_276948_(idx, (Component)line, (Component)filteredLine);
            }
            return text;
        }, front);
        this.setEditingPlayer(null);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean updateText(UnaryOperator<SignText> modifier, boolean front) {
        return this.setText((SignText)modifier.apply(this.getText(front)), front);
    }

    public boolean setText(SignText text, boolean front) {
        return front ? this.setFrontText(text) : this.setBackText(text);
    }

    public boolean setFrontText(SignText text) {
        if (text != this.frontText) {
            this.frontText = text;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean setBackText(SignText text) {
        if (text != this.backText) {
            this.backText = text;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.waxed != waxed) {
            this.waxed = waxed;
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean canExecuteCommands(boolean front, Player pPlayer) {
        return this.isWaxed() && this.getText(front).m_276807_(pPlayer);
    }

    public boolean tryExecuteCommands(Player player, Level level, BlockPos pos, boolean front) {
        boolean executed = false;
        for (Component line : this.getText(front).m_276945_(player.m_143387_())) {
            ClickEvent event = line.m_7383_().m_131182_();
            if (event == null || event.m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            player.m_20194_().m_129892_().m_230957_(FramedSignBlockEntity.getCommandSource((ServerPlayer)player, (ServerLevel)level, pos), event.m_130623_());
            executed = true;
        }
        return executed;
    }

    private static CommandSourceStack getCommandSource(ServerPlayer player, ServerLevel level, BlockPos pos) {
        String nameString = player == null ? "Sign" : player.m_7755_().getString();
        MutableComponent name = player == null ? Component.m_237113_((String)"Sign") : player.m_5446_();
        Vec3 posVec = Vec3.m_82512_((Vec3i)pos);
        return new CommandSourceStack(CommandSource.f_80164_, posVec, Vec2.f_82462_, level, 2, nameString, (Component)name, level.m_7654_(), (Entity)player);
    }

    @Nullable
    public UUID getEditingPlayer() {
        return this.editingPlayer;
    }

    public void setEditingPlayer(@Nullable UUID player) {
        this.editingPlayer = player;
    }

    public boolean m_6326_() {
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedSignBlockEntity be) {
        Player player;
        if (be.editingPlayer != null && be.isTooFarAwayToEdit(player = level.m_46003_(be.editingPlayer))) {
            be.editingPlayer = null;
        }
    }

    public boolean isTooFarAwayToEdit(Player player) {
        return player == null || player.m_20275_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()) > 64.0;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.renderBounds = state.m_60808_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_);
    }

    public AABB getRenderBoundingBox() {
        return this.renderBounds;
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt) {
        super.writeToDataPacket(nbt);
        this.writeToNbt(nbt);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt) {
        this.readFromNbt(nbt);
        return super.readFromDataPacket(nbt);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.writeToNbt(nbt);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        this.readFromNbt(nbt);
    }

    private void writeToNbt(CompoundTag nbt) {
        SignText.f_276558_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.frontText).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> nbt.m_128365_("front_text", tag));
        SignText.f_276558_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.backText).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> nbt.m_128365_("back_text", tag));
        nbt.m_128379_("waxed", this.waxed);
    }

    private void readFromNbt(CompoundTag nbt) {
        if (nbt.m_128441_("front_text")) {
            SignText.f_276558_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("front_text")).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> {
                this.frontText = FramedSignBlockEntity.loadLines(this.f_58857_, this.f_58858_, tag);
            });
        }
        if (nbt.m_128441_("back_text")) {
            SignText.f_276558_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128469_("back_text")).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> {
                this.backText = FramedSignBlockEntity.loadLines(this.f_58857_, this.f_58858_, tag);
            });
        }
        this.waxed = nbt.m_128471_("waxed");
    }

    private static SignText loadLines(Level level, BlockPos pos, SignText text) {
        for (int i = 0; i < 4; ++i) {
            Component line = FramedSignBlockEntity.loadLine(level, pos, text.m_277138_(i, false));
            Component lineFiltered = FramedSignBlockEntity.loadLine(level, pos, text.m_277138_(i, true));
            text = text.m_276948_(i, line, lineFiltered);
        }
        return text;
    }

    private static Component loadLine(Level level, BlockPos pos, Component line) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            try {
                return ComponentUtils.m_130731_((CommandSourceStack)FramedSignBlockEntity.getCommandSource(null, serverlevel, pos), (Component)line, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public CompoundTag writeToBlueprint() {
        CompoundTag tag = this.m_187482_();
        tag.m_128473_("front_text");
        tag.m_128473_("back_text");
        tag.m_128473_("waxed");
        return tag;
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        this.writeToNbt(nbt);
        super.m_183515_(nbt);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("text0") || nbt.m_128441_("text1") || nbt.m_128441_("text2") || nbt.m_128441_("text3") || nbt.m_128441_("glowingText") || nbt.m_128441_("color")) {
            for (int i = 0; i < 4; ++i) {
                String text = nbt.m_128461_("text" + i);
                MutableComponent line = Component.Serializer.m_130701_((String)(text.isEmpty() ? "\"\"" : text));
                if (line == null) continue;
                this.frontText.m_276913_(i, (Component)line);
            }
            this.frontText.m_277132_(nbt.m_128471_("glowingText"));
            this.frontText.m_276901_(DyeColor.m_41057_((String)nbt.m_128461_("color"), (DyeColor)DyeColor.BLACK));
            return;
        }
        this.readFromNbt(nbt);
    }

    public static FramedSignBlockEntity normalSign(BlockPos pos, BlockState state) {
        return new FramedSignBlockEntity(FBContent.BE_TYPE_FRAMED_SIGN.get(), pos, state);
    }

    public static FramedSignBlockEntity hangingSign(BlockPos pos, BlockState state) {
        return new FramedSignBlockEntity(FBContent.BE_TYPE_FRAMED_HANGING_SIGN.get(), pos, state);
    }
}

