/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data;

import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.blueprint.CollapsibleBlockCopyBehaviour;
import xfacthd.framedblocks.common.data.blueprint.DoorCopyBehaviour;
import xfacthd.framedblocks.common.data.blueprint.DoubleBlockCopyBehaviour;
import xfacthd.framedblocks.common.data.blueprint.DoublePanelCopyBehaviour;
import xfacthd.framedblocks.common.data.blueprint.DoubleSlabCopyBehaviour;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public final class BlueprintBehaviours {
    public static void register() {
        DoubleBlockCopyBehaviour doubleBlockBehaviour = new DoubleBlockCopyBehaviour();
        FBContent.getRegisteredBlocks().stream().map(RegistryObject::get).filter(IFramedBlock.class::isInstance).filter(b -> ((IFramedBlock)b).getBlockType().isDoubleBlock()).forEach(block -> {
            if (block == FBContent.BLOCK_FRAMED_DOUBLE_SLAB.get()) {
                FramedBlueprintItem.registerBehaviour(new DoubleSlabCopyBehaviour(), block);
            } else if (block == FBContent.BLOCK_FRAMED_DOUBLE_PANEL.get()) {
                FramedBlueprintItem.registerBehaviour(new DoublePanelCopyBehaviour(), block);
            } else {
                FramedBlueprintItem.registerBehaviour(doubleBlockBehaviour, block);
            }
        });
        FramedBlueprintItem.registerBehaviour(new DoorCopyBehaviour(), (Block)FBContent.BLOCK_FRAMED_DOOR.get(), (Block)FBContent.BLOCK_FRAMED_IRON_DOOR.get());
        FramedBlueprintItem.registerBehaviour(new CollapsibleBlockCopyBehaviour(), (Block)FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK.get());
    }

    private BlueprintBehaviours() {
    }
}

