/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pillar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_PILLAR})
public final class PillarSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object;
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
        if (axis == side.m_122434_() && (object = adjState.m_60734_()) instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_PILLAR -> PillarSkipPredicate.testAgainstPillar(axis, adjState);
                case BlockType.FRAMED_HALF_PILLAR -> PillarSkipPredicate.testAgainstHalfPillar(adjState, side);
                case BlockType.FRAMED_WALL -> PillarSkipPredicate.testAgainstWall(axis, adjState);
                case BlockType.FRAMED_THICK_LATTICE -> PillarSkipPredicate.testAgainstThickLattice(axis, adjState);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_PILLAR})
    private static boolean testAgainstPillar(Direction.Axis axis, BlockState adjState) {
        return axis == adjState.m_61143_((Property)BlockStateProperties.f_61365_);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_PILLAR})
    private static boolean testAgainstHalfPillar(BlockState adjState, Direction side) {
        return adjState.m_61143_((Property)BlockStateProperties.f_61372_) == side.m_122424_();
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_WALL})
    private static boolean testAgainstWall(Direction.Axis axis, BlockState adjState) {
        return axis == Direction.Axis.Y && (Boolean)adjState.m_61143_((Property)BlockStateProperties.f_61366_) != false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_THICK_LATTICE})
    private static boolean testAgainstThickLattice(Direction.Axis axis, BlockState adjState) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> (Boolean)adjState.m_61143_((Property)FramedProperties.X_AXIS);
            case Direction.Axis.Y -> (Boolean)adjState.m_61143_((Property)FramedProperties.Y_AXIS);
            case Direction.Axis.Z -> (Boolean)adjState.m_61143_((Property)FramedProperties.Z_AXIS);
        };
    }
}

