/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.ISlopeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.InnerThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.ThreewayCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_CORNER_SLOPE})
public final class CornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_SLOPE -> CornerSkipPredicate.testAgainstCorner(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE -> CornerSkipPredicate.testAgainstInnerCorner(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_CORNER -> CornerSkipPredicate.testAgainstDoubleCorner(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_RAIL_SLOPE, BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE -> CornerSkipPredicate.testAgainstSlope(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE -> CornerSkipPredicate.testAgainstDoubleSlope(dir, type, adjState, side);
                case BlockType.FRAMED_PRISM_CORNER, BlockType.FRAMED_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstThreewayCorner(dir, type, adjState, side);
                case BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_INNER_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstInnerThreewayCorner(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_PRISM_CORNER, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER -> CornerSkipPredicate.testAgainstDoubleThreewayCorner(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> CornerSkipPredicate.testAgainstHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> CornerSkipPredicate.testAgainstDividedSlope(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> CornerSkipPredicate.testAgainstDoubleHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> CornerSkipPredicate.testAgainstVerticalHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE -> CornerSkipPredicate.testAgainstVerticalDoubleHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> CornerSkipPredicate.testAgainstSlopedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> CornerSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(CornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE})
    private static boolean testAgainstInnerCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.m_61143_(PropertyHolder.CORNER_TYPE));
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerCornerSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_CORNER, partTargets={BlockType.FRAMED_INNER_CORNER_SLOPE, BlockType.FRAMED_CORNER_SLOPE})
    private static boolean testAgainstDoubleCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstInnerCorner(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstCorner(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE, BlockType.FRAMED_RAIL_SLOPE, BlockType.FRAMED_POWERED_RAIL_SLOPE, BlockType.FRAMED_DETECTOR_RAIL_SLOPE, BlockType.FRAMED_ACTIVATOR_RAIL_SLOPE})
    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_POWERED_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_DETECTOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE}), @CullTest.DoubleTarget(value=BlockType.FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE, partTargets={BlockType.FRAMED_SLOPE})})
    private static boolean testAgainstSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        ISlopeBlock block = (ISlopeBlock)adjState.m_60734_();
        Direction adjDir = block.getFacing(adjState);
        SlopeType adjType = block.getSlopeType(adjState);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopeSkipPredicate.getTriDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE, partTargets={BlockType.FRAMED_SLOPE})
    private static boolean testAgainstDoubleSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstSlope(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_THREEWAY_CORNER, BlockType.FRAMED_PRISM_CORNER})
    private static boolean testAgainstThreewayCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(ThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_INNER_PRISM_CORNER})
    private static boolean testAgainstInnerThreewayCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(InnerThreewayCornerSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTargets(value={@CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_THREEWAY_CORNER, partTargets={BlockType.FRAMED_INNER_THREEWAY_CORNER, BlockType.FRAMED_THREEWAY_CORNER}), @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PRISM_CORNER, partTargets={BlockType.FRAMED_INNER_PRISM_CORNER, BlockType.FRAMED_PRISM_CORNER})})
    private static boolean testAgainstDoubleThreewayCorner(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstInnerThreewayCorner(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstThreewayCorner(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(HalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE, BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return CornerSkipPredicate.testAgainstVerticalHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstVerticalHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
        }
        return CornerSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean top = type.isTop();
        if (!type.isHorizontal() || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalDoubleHalfSlope(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return CornerSkipPredicate.testAgainstVerticalHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || CornerSkipPredicate.testAgainstVerticalHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        boolean top = type.isTop();
        if (!type.isHorizontal() || !top && side != Direction.DOWN || top && side != Direction.UP) {
            return false;
        }
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(SlopedStairsSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, CornerType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return CornerSkipPredicate.getTriDir(dir, type, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    public static TriangleDir getTriDir(Direction dir, CornerType type, Direction side) {
        if (type.isHorizontal()) {
            boolean top = type.isTop();
            boolean right = type.isRight();
            if (!top && side == Direction.DOWN || top && side == Direction.UP) {
                return TriangleDir.fromDirections(dir, right ? dir.m_122427_() : dir.m_122428_());
            }
            if (!right && side == dir.m_122428_() || right && side == dir.m_122427_()) {
                return TriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN);
            }
        } else {
            if (side == dir) {
                return TriangleDir.fromDirections(dir.m_122428_(), type == CornerType.TOP ? Direction.UP : Direction.DOWN);
            }
            if (side == dir.m_122428_()) {
                return TriangleDir.fromDirections(dir, type == CornerType.TOP ? Direction.UP : Direction.DOWN);
            }
        }
        return TriangleDir.NULL;
    }
}

