/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
public final class SmallCornerSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstSmallDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstLargeDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstInverseDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstExtendedDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstStackedCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstStackedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstDoubleSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> SmallCornerSlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> SmallCornerSlopePanelSkipPredicate.testAgainstSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> SmallCornerSlopePanelSkipPredicate.testAgainstCornerPillar(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> SmallCornerSlopePanelSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> SmallCornerSlopePanelSkipPredicate.testAgainstHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> SmallCornerSlopePanelSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> SmallCornerSlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> SmallCornerSlopePanelSkipPredicate.testAgainstDividedPanelVert(dir, top, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> SmallCornerSlopePanelSkipPredicate.testAgainstDividedStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (SmallCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SmallCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL, BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSmallCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstStackedCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstCornerPillar(dir, top, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL}, ignoredParts={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstStackedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return SmallCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SlopePanelSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return SmallCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return SmallCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean ajdRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, ajdRight, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        return SmallCornerSlopePanelSkipPredicate.getCornerDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_CORNER_PILLAR}, ignoredParts={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstCornerPillar(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstCornerPillar(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstCornerPillar(dir, top, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return SmallCornerSlopePanelSkipPredicate.testAgainstHalfStairs(dir, top, (BlockState)states.m_14418_(), side) || SmallCornerSlopePanelSkipPredicate.testAgainstHalfStairs(dir, top, (BlockState)states.m_14419_(), side);
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side == dir) {
            return HalfTriangleDir.fromDirections(dir.m_122428_(), top ? Direction.UP : Direction.DOWN, true);
        }
        if (side == dir.m_122428_()) {
            return HalfTriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN, true);
        }
        return HalfTriangleDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return CornerDir.fromDirections(side, dir, dir.m_122428_());
        }
        return CornerDir.NULL;
    }
}

