/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
public final class FlatSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            boolean topHalf = (Boolean)state.m_61143_((Property)PropertyHolder.TOP_HALF);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstElevatedDoubleSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_SLAB -> FlatSlopeSlabCornerSkipPredicate.testAgainstStackedSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInverseDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatStackedSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER -> FlatSlopeSlabCornerSkipPredicate.testAgainstFlatStackedInnerSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstSmallDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstLargeDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstInverseDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstStackedCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> FlatSlopeSlabCornerSkipPredicate.testAgainstStackedInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.m_61143_((Property)PropertyHolder.TOP_HALF);
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SlopeSlabSkipPredicate.getTriDir(adjDir, adjTopHalf, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstInverseDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstElevatedDoubleSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_SLAB, partTargets={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstStackedSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER, BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_ELEV_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_ELEV_INNER_DOUBLE_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerDoubleSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatStackedSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return FlatSlopeSlabCornerSkipPredicate.getTriDir(dir, topHalf, top, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstInverseDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14418_(), side) || FlatSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return FlatSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, (BlockState)states.m_14419_(), side);
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean topHalf, boolean top, Direction side) {
        if (side == dir || side == dir.m_122428_()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            Direction shortEdge = side == dir ? dir.m_122428_() : dir;
            return HalfTriangleDir.fromDirections(longEdge, shortEdge, topHalf == top);
        }
        return HalfTriangleDir.NULL;
    }
}

