/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_VERTICAL_STAIRS})
public final class VerticalStairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            StairsType type = (StairsType)((Object)state.m_61143_(PropertyHolder.STAIRS_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_VERTICAL_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalDoubleStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalDividedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_STAIRS -> VerticalStairsSkipPredicate.testAgainstStairs(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> VerticalStairsSkipPredicate.testAgainstDoubleStairs(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> VerticalStairsSkipPredicate.testAgainstHalfStairs(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> VerticalStairsSkipPredicate.testAgainstDividedStairs(dir, type, adjState, side);
                case BlockType.FRAMED_PANEL -> VerticalStairsSkipPredicate.testAgainstPanel(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> VerticalStairsSkipPredicate.testAgainstDoublePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> VerticalStairsSkipPredicate.testAgainstCorner(dir, type, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> VerticalStairsSkipPredicate.testAgainstPillar(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> VerticalStairsSkipPredicate.testAgainstDividedPanelVert(dir, type, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> VerticalStairsSkipPredicate.testAgainstEdge(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> VerticalStairsSkipPredicate.testAgainstDividedSlab(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> VerticalStairsSkipPredicate.testAgainstDividedPanelHor(dir, type, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstDoubleSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstInverseDoubleSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedDoubleSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstStackedSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatStackedSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> VerticalStairsSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstSmallDoubleCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstSmallDoubleCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstLargeDoubleCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstLargeDoubleCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstInverseDoubleCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstInverseDoubleCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedDoubleCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstExtendedDoubleCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstExtendedInnerDoubleCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstStackedCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstStackedCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL -> VerticalStairsSkipPredicate.testAgainstStackedInnerCornerSlopePanel(dir, type, adjState, side);
                case BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W -> VerticalStairsSkipPredicate.testAgainstStackedInnerCornerSlopePanelWall(dir, type, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> VerticalStairsSkipPredicate.testAgainstHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> VerticalStairsSkipPredicate.testAgainstDividedSlope(dir, type, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> VerticalStairsSkipPredicate.testAgainstDoubleHalfSlope(dir, type, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> VerticalStairsSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.m_122424_()))) {
            return true;
        }
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(VerticalStairsSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_STAIRS, BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstVerticalDoubleStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstVerticalStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstPillar(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(VerticalHalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_VERTICAL_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalDividedStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstVerticalHalfStairs(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)BlockStateProperties.f_61374_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)BlockStateProperties.f_61398_);
        Half adjHalf = (Half)adjState.m_61143_((Property)BlockStateProperties.f_61402_);
        if (VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return true;
        }
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(StairsSkipPredicate.getCornerDir(adjDir, adjShape, adjHalf, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_STAIRS, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDoubleStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return true;
        }
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(HalfStairsSkipPredicate.getCornerDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_STAIRS, partTargets={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstDividedStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstHalfStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstHalfStairs(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_PANEL, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstDoublePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstPanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SlabCornerSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstPillar(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(CornerPillarSkipPredicate.getCornerDir(adjDir, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_VERTICAL, partTargets={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstDividedPanelVert(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPillar(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstPillar(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstEdge(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return true;
        }
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SlabEdgeSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLAB, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedSlab(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL, partTargets={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstDividedPanelHor(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstDoubleSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXTENDED_SLOPE_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstExtendedSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_SLOPE_PANEL, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstStackedSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatDoubleSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL})
    private static boolean testAgainstFlatStackedSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPanel(dir, type, (BlockState)states.m_14418_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER, partTargets={BlockType.FRAMED_PANEL, BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SmallCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SmallCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(SmallInnerCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getCornerDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getCornerDir(dir, type, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getCornerDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.m_122424_()));
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getStairDir(dir, type, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallDoubleCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallDoubleCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeDoubleCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeDoubleCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstInverseDoubleCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_INV_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstInverseDoubleCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL, BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedDoubleCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedDoubleCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_EXT_INNER_DOUBLE_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W, BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerDoubleCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_CORNER_PILLAR, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstStackedCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstPillar(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_SLAB_EDGE, BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstEdge(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL, partTargets={BlockType.FRAMED_VERTICAL_STAIRS, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstStackedInnerCornerSlopePanel(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstVerticalStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_W, partTargets={BlockType.FRAMED_STAIRS, BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstStackedInnerCornerSlopePanelWall(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstStairs(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()));
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DIVIDED_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDividedSlope(Direction dir, StairsType type, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.DoubleTarget(value=BlockType.FRAMED_DOUBLE_HALF_SLOPE, partTargets={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstDoubleHalfSlope(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return VerticalStairsSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14418_(), side) || VerticalStairsSkipPredicate.testAgainstHalfSlope(dir, type, (BlockState)states.m_14419_(), side);
    }

    @CullTest.SingleTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, StairsType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        return VerticalStairsSkipPredicate.getHalfDir(dir, type, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()));
    }

    public static TriangleDir getStairDir(Direction dir, StairsType type, Direction side) {
        if (side == Direction.DOWN && type != StairsType.BOTTOM_CORNER || side == Direction.UP && type != StairsType.TOP_CORNER) {
            return TriangleDir.fromDirections(dir, dir.m_122428_());
        }
        if (side == dir && type != StairsType.VERTICAL) {
            Direction dirTwo = type == StairsType.TOP_CORNER ? Direction.DOWN : Direction.UP;
            return TriangleDir.fromDirections(dir.m_122428_(), dirTwo);
        }
        if (side == dir.m_122428_() && type != StairsType.VERTICAL) {
            Direction dirTwo = type == StairsType.TOP_CORNER ? Direction.DOWN : Direction.UP;
            return TriangleDir.fromDirections(dir, dirTwo);
        }
        return TriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, StairsType type, Direction side) {
        if (type != StairsType.VERTICAL) {
            return HalfDir.NULL;
        }
        if (side == dir.m_122427_()) {
            return HalfDir.fromDirections(side, dir);
        }
        if (side == dir.m_122424_()) {
            return HalfDir.fromDirections(side, dir.m_122428_());
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, StairsType type, Direction side) {
        Direction dirTwo;
        if (type == StairsType.VERTICAL) {
            return CornerDir.NULL;
        }
        Direction direction = dirTwo = type == StairsType.TOP_CORNER ? Direction.DOWN : Direction.UP;
        if (side == dirTwo.m_122424_()) {
            return CornerDir.fromDirections(side, dir, dir.m_122428_());
        }
        if (side == dir.m_122424_()) {
            return CornerDir.fromDirections(side, dir.m_122428_(), dirTwo);
        }
        if (side == dir.m_122427_()) {
            return CornerDir.fromDirections(side, dir, dirTwo);
        }
        return CornerDir.NULL;
    }
}

