/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways;

import com.mojang.brigadier.CommandDispatcher;
import dev.shadowsoffire.gateways.command.GatewayCommand;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GatewayEvents {
    @SubscribeEvent
    public void commands(RegisterCommandsEvent e) {
        GatewayCommand.register((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    @SubscribeEvent
    public void teleport(EntityTeleportEvent e) {
        GatewayEntity gate = GatewayEntity.getOwner(e.getEntity());
        if (gate != null && gate.getGateway().rules().failOnOutOfBounds() && gate.m_20275_(e.getTargetX(), e.getTargetY(), e.getTargetZ()) >= gate.getGateway().getLeashRangeSq()) {
            e.setTargetX(gate.m_20185_() + 0.5 * (double)gate.m_20205_());
            e.setTargetY(gate.m_20186_() + 0.5 * (double)gate.m_20206_());
            e.setTargetZ(gate.m_20189_() + 0.5 * (double)gate.m_20205_());
        }
    }

    @SubscribeEvent
    public void convert(LivingConversionEvent.Post e) {
        LivingEntity entity = e.getEntity();
        GatewayEntity gate = GatewayEntity.getOwner((Entity)entity);
        if (gate != null) {
            gate.handleConversion((Entity)entity, e.getOutcome());
        }
    }

    @SubscribeEvent
    public void hurt(LivingHurtEvent e) {
        GatewayEntity gate = GatewayEntity.getOwner((Entity)e.getEntity());
        if (gate != null) {
            Player p;
            boolean isPlayerDamage;
            Entity entity = e.getSource().m_7639_();
            boolean bl = isPlayerDamage = entity instanceof Player && !((p = (Player)entity) instanceof FakePlayer);
            if (!isPlayerDamage && gate.getGateway().rules().playerDamageOnly()) {
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void despawn(MobSpawnEvent.AllowDespawn e) {
        if (GatewayEntity.getOwner((Entity)e.getEntity()) != null) {
            e.setResult(Event.Result.DENY);
        }
    }
}

