/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.gui;

import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.data.CachedModel;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.gui.SimChamberContainer;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.hostilenetworks.tile.SimChamberTileEntity;
import dev.shadowsoffire.placebo.screen.PlaceboContainerScreen;
import dev.shadowsoffire.placebo.screen.TickableText;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class SimChamberScreen
extends PlaceboContainerScreen<SimChamberContainer> {
    public static final int WIDTH = 232;
    public static final int HEIGHT = 230;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/sim_chamber.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private List<TickableText> body = new ArrayList<TickableText>(7);
    private SimChamberTileEntity.FailureState lastFailState = SimChamberTileEntity.FailureState.NONE;
    private boolean runtimeTextLoaded = false;
    private static final Component ERROR = Component.m_237113_((String)"ERROR").m_130940_(ChatFormatting.OBFUSCATED);

    public SimChamberScreen(SimChamberContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 232;
        this.f_97727_ = 230;
    }

    protected void m_280072_(GuiGraphics gfx, int pX, int pY) {
        if (this.m_6774_(211, 48, 7, 87, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((SimChamberContainer)this.f_97732_).getEnergyStored(), HostileConfig.simPowerCap}));
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.isValid()) {
                txt.add(Component.m_237110_((String)"hostilenetworks.gui.cost", (Object[])new Object[]{cModel.getModel().simCost()}));
            }
            gfx.m_280666_(this.f_96547_, txt, pX, pY);
        } else if (this.m_6774_(14, 48, 7, 87, pX, pY)) {
            CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
            if (cModel.isValid()) {
                ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(1);
                if (cModel.getTier() != cModel.getTier().next()) {
                    txt.add(Component.m_237110_((String)"hostilenetworks.gui.data", (Object[])new Object[]{cModel.getData() - cModel.getTierData(), cModel.getNextTierData() - cModel.getTierData()}));
                } else {
                    txt.add(Component.m_237115_((String)"hostilenetworks.gui.max_data").m_130940_(ChatFormatting.RED));
                }
                gfx.m_280666_(this.f_96547_, txt, pX, pY);
            }
        } else {
            super.m_280072_(gfx, pX, pY);
        }
    }

    protected void m_280003_(GuiGraphics gfx, int pX, int pY) {
        CachedModel cModel;
        int runtime = ((SimChamberContainer)this.f_97732_).getRuntime();
        if (runtime > 0) {
            int rTime = Math.min(99, Mth.m_14167_((float)(100.0f * (float)(300 - runtime) / 300.0f)));
            gfx.m_280056_(this.f_96547_, rTime + "%", 184, 123, 6478079, true);
        }
        if ((cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0)).isValid()) {
            int xOff = 18;
            String msg = I18n.m_118938_((String)"hostilenetworks.gui.target", (Object[])new Object[0]);
            gfx.m_280488_(this.f_96547_, msg, xOff, 9, 0xFFFFFF);
            gfx.m_280430_(this.f_96547_, (Component)cModel.getModel().name(), xOff += this.f_96547_.m_92895_(msg), 9, 65472);
            xOff = 18;
            msg = I18n.m_118938_((String)"hostilenetworks.gui.tier", (Object[])new Object[0]);
            Objects.requireNonNull(this.f_96547_);
            gfx.m_280488_(this.f_96547_, msg, xOff, 9 + 9 + 3, 0xFFFFFF);
            xOff += this.f_96547_.m_92895_(msg);
            msg = I18n.m_118938_((String)("hostilenetworks.tier." + cModel.getTier().name), (Object[])new Object[0]);
            Objects.requireNonNull(this.f_96547_);
            gfx.m_280488_(this.f_96547_, msg, xOff, 9 + 9 + 3, cModel.getTier().color.m_126665_().intValue());
            xOff = 18;
            msg = I18n.m_118938_((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]);
            Objects.requireNonNull(this.f_96547_);
            gfx.m_280488_(this.f_96547_, msg, xOff, 9 + (9 + 3) * 2, 0xFFFFFF);
            xOff += this.f_96547_.m_92895_(msg);
            DecimalFormat fmt = new DecimalFormat("##.##%");
            msg = fmt.format(cModel.getAccuracy());
            Objects.requireNonNull(this.f_96547_);
            gfx.m_280488_(this.f_96547_, msg, xOff, 9 + (9 + 3) * 2, cModel.getTier().color.m_126665_().intValue());
        }
        int left = 29;
        int top = 51;
        Objects.requireNonNull(this.f_96547_);
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.body) {
            t.render(this.f_96547_, gfx, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 29;
                continue;
            }
            left += t.getWidth(this.f_96547_);
        }
    }

    protected void m_7286_(GuiGraphics gfx, float pPartialTicks, int pX, int pY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        gfx.m_280163_(BASE, left + 8, top, 0.0f, 0.0f, 216, 141, 256, 256);
        gfx.m_280163_(BASE, left - 14, top, 0.0f, 141.0f, 18, 18, 256, 256);
        int energyHeight = 87 - Mth.m_14167_((float)(87.0f * (float)((SimChamberContainer)this.f_97732_).getEnergyStored() / (float)HostileConfig.simPowerCap));
        gfx.m_280163_(BASE, left + 211, top + 48, 18.0f, 141.0f, 7, energyHeight, 256, 256);
        int dataHeight = 87;
        CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
        if (cModel.isValid()) {
            ModelTier next;
            int data = cModel.getData();
            ModelTier tier = cModel.getTier();
            dataHeight = tier == (next = tier.next()) ? 0 : 87 - Mth.m_14167_((float)(87.0f * (float)(data - cModel.getTierData()) / (float)(cModel.getNextTierData() - cModel.getTierData())));
        }
        gfx.m_280163_(BASE, left + 14, top + 48, 18.0f, 141.0f, 7, dataHeight, 256, 256);
        gfx.m_280163_(PLAYER, left + 28, top + 145, 0.0f, 0.0f, 176, 90, 256, 256);
    }

    public void m_181908_() {
        if (((SimChamberContainer)this.f_97732_).getFailState() != SimChamberTileEntity.FailureState.NONE) {
            SimChamberTileEntity.FailureState oState = this.lastFailState;
            this.lastFailState = ((SimChamberContainer)this.f_97732_).getFailState();
            if (oState != this.lastFailState) {
                this.body.clear();
                String[] msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[0]).split("\\n");
                if (this.lastFailState == SimChamberTileEntity.FailureState.INPUT) {
                    CachedModel cModel = new CachedModel(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_(), 0);
                    Component name = ERROR;
                    if (cModel.isValid()) {
                        name = cModel.getModel().input().m_41786_();
                    }
                    msg = I18n.m_118938_((String)this.lastFailState.getKey(), (Object[])new Object[]{name.getString()}).split("\\n");
                }
                for (String s : msg) {
                    this.body.add(new TickableText(s, 0xFFFFFF));
                }
            }
            this.runtimeTextLoaded = false;
        } else if (!this.runtimeTextLoaded) {
            int ticks = 300 - ((SimChamberContainer)this.f_97732_).getRuntime();
            float speed = 0.65f;
            this.body.clear();
            int iters = DataModelItem.getIters(((SimChamberContainer)this.f_97732_).m_38853_(0).m_7993_());
            for (int i = 0; i < 7; ++i) {
                TickableText txt = new TickableText(I18n.m_118938_((String)("hostilenetworks.run." + i), (Object[])new Object[]{iters}), 0xFFFFFF, i != 0 && i != 5, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                if (i == 0) {
                    txt = new TickableText("v" + HostileNetworks.VERSION, ChatFormatting.GOLD.m_126665_().intValue(), true, speed);
                    this.body.add(txt.setTicks(ticks));
                    ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
                    continue;
                }
                if (i != 5) continue;
                String key = "hostilenetworks.color_text." + (((SimChamberContainer)this.f_97732_).didPredictionSucceed() ? "success" : "failed");
                txt = new TickableText(I18n.m_118938_((String)key, (Object[])new Object[0]), (((SimChamberContainer)this.f_97732_).didPredictionSucceed() ? ChatFormatting.GOLD : ChatFormatting.RED).m_126665_().intValue(), true, speed);
                this.body.add(txt.setTicks(ticks));
                ticks = Math.max(0, ticks - txt.getMaxUsefulTicks());
            }
            this.runtimeTextLoaded = true;
            this.lastFailState = SimChamberTileEntity.FailureState.NONE;
        }
        TickableText.tickList(this.body);
        if (((SimChamberContainer)this.f_97732_).getRuntime() == 0) {
            this.runtimeTextLoaded = false;
        }
    }
}

