/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;

public abstract class WireType
implements ILocalHandlerProvider {
    public static final String LV_CATEGORY = "LV";
    public static final String MV_CATEGORY = "MV";
    public static final String HV_CATEGORY = "HV";
    public static final String STRUCTURE_CATEGORY = "STRUCTURE";
    public static final String REDSTONE_CATEGORY = "REDSTONE";
    private static final LinkedHashSet<WireType> values = new LinkedHashSet();
    public static WireType COPPER;
    public static WireType ELECTRUM;
    public static WireType STEEL;
    public static WireType STRUCTURE_ROPE;
    public static WireType STRUCTURE_STEEL;
    public static WireType REDSTONE;
    public static WireType COPPER_INSULATED;
    public static WireType ELECTRUM_INSULATED;
    public static WireType INTERNAL_CONNECTION;

    public static LinkedHashSet<WireType> getValues() {
        return values;
    }

    public static WireType getValue(String name) {
        for (WireType type : values) {
            if (type == null || !type.getUniqueName().equals(name)) continue;
            return type;
        }
        return COPPER;
    }

    public WireType() {
        values.add(this);
    }

    public abstract String getUniqueName();

    public abstract int getColour(Connection var1);

    public abstract double getSlack();

    public abstract int getMaxLength();

    public abstract ItemStack getWireCoil(Connection var1);

    public abstract double getRenderDiameter();

    @Nonnull
    public abstract String getCategory();

    public static Collection<WireType> getIEWireTypes() {
        return ImmutableList.of((Object)COPPER, (Object)ELECTRUM, (Object)STEEL, (Object)STRUCTURE_ROPE, (Object)STRUCTURE_STEEL, (Object)REDSTONE, (Object)COPPER_INSULATED, (Object)ELECTRUM_INSULATED);
    }
}

