/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.mixin.accessors.client.RenderChunkAccess;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.modelsplitter.model.UVCoords;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ConnectionRenderer
implements ResourceManagerReloadListener {
    private static final LoadingCache<SectionKey, List<RenderedSegment>> SEGMENT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build(CacheLoader.from(ConnectionRenderer::renderSectionForCache));
    private static final ResettableLazy<TextureAtlasSprite> WIRE_TEXTURE = new ResettableLazy(() -> Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(ImmersiveEngineering.rl("block/wire")));

    public void m_6213_(@Nonnull ResourceManager pResourceManager) {
        WIRE_TEXTURE.reset();
        ConnectionRenderer.resetCache();
    }

    public static void resetCache() {
        SEGMENT_CACHE.invalidateAll();
    }

    public static void renderConnectionsInSection(Set<RenderType> layers, ChunkBufferBuilderPack buffers, @Nullable BlockAndTintGetter region, ChunkRenderDispatcher.RenderChunk renderChunk) {
        if (region == null) {
            return;
        }
        BlockPos chunkOrigin = renderChunk.m_112839_();
        SectionPos section = SectionPos.m_123199_((BlockPos)chunkOrigin);
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork((Level)Minecraft.m_91087_().f_91073_);
        List<WireCollisionData.ConnectionSegments> connectionParts = globalNet.getCollisionData().getWiresIn(section);
        if (connectionParts == null || connectionParts.isEmpty()) {
            return;
        }
        RenderType renderType = RenderType.m_110451_();
        BufferBuilder builder = buffers.m_108839_(renderType);
        if (layers.add(renderType)) {
            ((RenderChunkAccess)renderChunk).invokeBeginLayer(builder);
        }
        for (WireCollisionData.ConnectionSegments connection : connectionParts) {
            ConnectionPoint connectionOrigin = connection.connection().getEndA();
            ConnectionRenderer.renderSegments((VertexConsumer)builder, connection, connectionOrigin.getX() - chunkOrigin.m_123341_(), connectionOrigin.getY() - chunkOrigin.m_123342_(), connectionOrigin.getZ() - chunkOrigin.m_123343_(), region);
        }
    }

    public static void renderSegments(VertexConsumer out, WireCollisionData.ConnectionSegments toRender, int offX, int offY, int offZ, BlockAndTintGetter level) {
        Connection connection = toRender.connection();
        int color = connection.type.getColour(connection);
        double radius = connection.type.getRenderDiameter() / 2.0;
        int lastLight = 0;
        List renderedSection = (List)SEGMENT_CACHE.getUnchecked((Object)new SectionKey(radius, color, connection.getCatenaryData(), toRender.firstPointToRender(), toRender.lastPointToRender()));
        for (int i = 0; i < renderedSection.size(); ++i) {
            RenderedSegment segment = (RenderedSegment)renderedSection.get(i);
            if (i == 0) {
                lastLight = ConnectionRenderer.getLight(connection, segment.offsetStart, level);
            }
            int nextLight = ConnectionRenderer.getLight(connection, segment.offsetEnd, level);
            segment.render(lastLight, nextLight, OverlayTexture.f_118083_, offX, offY, offZ, out);
            lastLight = nextLight;
        }
    }

    public static void renderConnection(VertexConsumer out, Connection.CatenaryData catenaryData, double radius, int color, int light, int overlay) {
        List section = (List)SEGMENT_CACHE.getUnchecked((Object)new SectionKey(radius, color, catenaryData, 0, 16));
        for (RenderedSegment renderedSegment : section) {
            renderedSegment.render(light, light, overlay, 0, 0, 0, out);
        }
    }

    private static List<RenderedSegment> renderSectionForCache(SectionKey key) {
        Connection.CatenaryData catenaryData = key.catenaryShape();
        ArrayList<RenderedSegment> segments = new ArrayList<RenderedSegment>(key.lastIndex - key.firstIndex);
        for (int startIndex = key.firstIndex; startIndex < key.lastIndex; ++startIndex) {
            ArrayList<Vertex> vertices = new ArrayList<Vertex>(16);
            Vec3 start = key.catenaryShape().getRenderPoint(startIndex);
            Vec3 end = key.catenaryShape().getRenderPoint(startIndex + 1);
            Vec3 horNormal = key.catenaryShape().isVertical() ? new Vec3(1.0, 0.0, 0.0) : new Vec3(-catenaryData.delta().f_82481_, 0.0, catenaryData.delta().f_82479_).m_82541_();
            Vec3 verticalNormal = start.m_82546_(end).m_82537_(horNormal).m_82541_();
            Vec3 horRadius = horNormal.m_82490_(key.radius());
            Vec3 verticalRadius = verticalNormal.m_82490_(-key.radius());
            ConnectionRenderer.renderBidirectionalQuad(vertices, start, end, horRadius, key.color(), verticalNormal);
            ConnectionRenderer.renderBidirectionalQuad(vertices, start, end, verticalRadius, key.color(), horNormal);
            segments.add(new RenderedSegment(vertices, (Vec3i)BlockPos.m_274446_((Position)start), (Vec3i)BlockPos.m_274446_((Position)end)));
        }
        return segments;
    }

    private static int getLight(Connection connection, Vec3i point, BlockAndTintGetter level) {
        return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)connection.getEndA().position().m_121955_(point));
    }

    private static int getByte(int value, int lowestBit) {
        return value >> lowestBit & 0xFF;
    }

    private static void renderBidirectionalQuad(List<Vertex> out, Vec3 start, Vec3 end, Vec3 radius, int color, Vec3 positiveNormal) {
        int i;
        TextureAtlasSprite texture = WIRE_TEXTURE.get();
        UVCoords[] uvs = new UVCoords[]{new UVCoords(texture.m_118409_(), texture.m_118411_()), new UVCoords(texture.m_118410_(), texture.m_118411_()), new UVCoords(texture.m_118410_(), texture.m_118412_()), new UVCoords(texture.m_118409_(), texture.m_118412_())};
        Vec3[] vertices = new Vec3[]{start.m_82549_(radius), end.m_82549_(radius), end.m_82546_(radius), start.m_82546_(radius)};
        for (i = 0; i < vertices.length; ++i) {
            out.add(ConnectionRenderer.vertex(vertices[i], uvs[i], color, positiveNormal, i == 0 || i == 3));
        }
        for (i = vertices.length - 1; i >= 0; --i) {
            out.add(ConnectionRenderer.vertex(vertices[i], uvs[i], color, positiveNormal.m_82490_(-1.0), i == 0 || i == 3));
        }
    }

    private static Vertex vertex(Vec3 point, UVCoords uv, int color, Vec3 normal, boolean lightForStart) {
        return new Vertex((float)point.f_82479_, (float)point.f_82480_, (float)point.f_82481_, (float)uv.u(), (float)uv.v(), (float)ConnectionRenderer.getByte(color, 16) / 255.0f, (float)ConnectionRenderer.getByte(color, 8) / 255.0f, (float)ConnectionRenderer.getByte(color, 0) / 255.0f, (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82480_, lightForStart);
    }

    private record SectionKey(double radius, int color, Connection.CatenaryData catenaryShape, int firstIndex, int lastIndex) {
    }

    private record RenderedSegment(List<Vertex> vertices, Vec3i offsetStart, Vec3i offsetEnd) {
        public void render(int lightStart, int lightEnd, int overlay, int offX, int offY, int offZ, VertexConsumer out) {
            for (Vertex v : this.vertices) {
                out.m_5954_((float)offX + v.posX, (float)offY + v.posY, (float)offZ + v.posZ, v.red, v.green, v.blue, 1.0f, v.texU, v.texV, overlay, v.lightForStart ? lightStart : lightEnd, v.normalX, v.normalY, v.normalZ);
            }
        }
    }

    private record Vertex(float posX, float posY, float posZ, float texU, float texV, float red, float green, float blue, float normalX, float normalY, float normalZ, boolean lightForStart) {
    }
}

