/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixerLogic;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Quaternionf;

public class MixerRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<MixerLogic.State>> {
    public static final String NAME = "mixer_agitator";
    public static DynamicModel AGITATOR;

    public void render(MultiblockBlockEntityMaster<MixerLogic.State> te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockBEHelper helper = te.getHelper();
        MixerLogic.State state = (MixerLogic.State)helper.getState();
        MultiblockOrientation orientation = helper.getContext().getLevel().getOrientation();
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        matrixStack.m_85836_();
        Direction front = orientation.front();
        matrixStack.m_85837_(front == Direction.SOUTH || front == Direction.WEST ? -0.5 : 0.5, 0.0, front == Direction.SOUTH || front == Direction.EAST ? 0.5 : -0.5);
        float agitator = state.animation_agitator - (!state.isActive ? 0.0f : (1.0f - partialTicks) * 9.0f);
        matrixStack.m_252781_(new Quaternionf().rotateY(agitator * ((float)Math.PI / 180)));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        blockRenderer.m_110937_().renderModel(matrixStack.m_85850_(), bufferIn.m_6299_(RenderType.m_110451_()), null, AGITATOR.get(), 1.0f, 1.0f, 1.0f, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, RenderType.m_110451_());
        matrixStack.m_85849_();
        matrixStack.m_85837_(front == Direction.SOUTH || front == Direction.WEST ? -0.5 : 0.5, -0.625, front == Direction.SOUTH || front == Direction.EAST ? 0.5 : -0.5);
        matrixStack.m_85841_(0.0625f, 1.0f, 0.0625f);
        matrixStack.m_252781_(new Quaternionf().rotateX(1.5707964f));
        for (int i = state.tank.getFluidTypes() - 1; i >= 0; --i) {
            FluidStack fs = state.tank.fluids.get(i);
            if (fs == null || fs.getFluid() == null) continue;
            float yy = (float)fs.getAmount() / (float)state.tank.getCapacity() * 1.0625f;
            matrixStack.m_252880_(0.0f, 0.0f, -yy);
            float w = i < state.tank.getFluidTypes() - 1 || (double)yy >= 0.125 ? 26.0f : 16.0f + yy / 0.0125f;
            GuiHelper.drawRepeatedFluidSprite(bufferIn.m_6299_(RenderType.m_110466_()), matrixStack, fs, -w / 2.0f, -w / 2.0f, w, w);
        }
        matrixStack.m_85849_();
    }
}

