/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.metal.CrafterPatternInventory;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.AssemblerShapes;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class AssemblerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State> {
    public static final int NUM_PATTERNS = 3;
    public static final int NUM_TANKS = 3;
    public static final int TANK_CAPACITY = 8000;
    public static final int ENERGY_CAPACITY = 32000;
    public static final int INVENTORY_SIZE = 21;
    private static final CapabilityPosition ITEM_INPUT = new CapabilityPosition(1, 1, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition FLUID_INPUT = new CapabilityPosition(1, 0, 2, RelativeBlockFace.BACK);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(1, 2, 1, RelativeBlockFace.UP);
    public static final BlockPos[] REDSTONE_PORTS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(2, 0, 1)};

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!context.getLevel().shouldTickModulo(16) || !state.rsState.isEnabled(context)) {
            return;
        }
        List<OutputBuffer> outputs = this.craftRecipes(context);
        for (OutputBuffer buffer : outputs) {
            for (int i = 0; i < buffer.results.size(); ++i) {
                this.outputStack(state, (ItemStack)buffer.results.get(i), buffer.id, i == 0);
            }
        }
        for (int i = 0; i < 3; ++i) {
            if (this.isRecipeIngredient(state, state.inventory.getStackInSlot(18 + i), i)) continue;
            state.inventory.setStackInSlot(18 + i, Utils.insertStackIntoInventory(state.output, state.inventory.getStackInSlot(18 + i), false));
        }
    }

    private List<OutputBuffer> craftRecipes(IMultiblockContext<State> ctx) {
        State state = ctx.getState();
        ArrayList<OutputBuffer> outputBuffer = new ArrayList<OutputBuffer>();
        for (int patternId = 0; patternId < state.patterns.length; ++patternId) {
            CrafterPatternInventory pattern = state.patterns[patternId];
            ItemStack output = ((ItemStack)pattern.inv.get(9)).m_41777_();
            if (output.m_41619_() || !this.canOutput(state, output, patternId)) continue;
            ArrayList<ItemStack> availableStacks = new ArrayList<ItemStack>();
            for (OutputBuffer bufferedStacks : outputBuffer) {
                availableStacks.addAll((Collection<ItemStack>)bufferedStacks.results);
            }
            for (ItemStack stack : state.inventory) {
                if (stack.m_41619_()) continue;
                availableStacks.add(stack);
            }
            List<RecipeQuery> queries = pattern.getQueries(ctx.getLevel().getRawLevel());
            if (queries == null) continue;
            int consumed = (Integer)IEServerConfig.MACHINES.assembler_consumption.get();
            if (!this.consumeIngredients(state, queries, availableStacks, false, null) || state.energy.extractEnergy(consumed, false) != consumed) continue;
            NonNullList outputList = NonNullList.m_122779_();
            outputList.add((Object)output);
            RecipeInputSources sources = new RecipeInputSources(pattern);
            this.consumeIngredients(state, queries, availableStacks, true, sources);
            NonNullList remainingItems = pattern.recipe.m_7457_((Container)Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, sources.gridItems));
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack rem = (ItemStack)remainingItems.get(i);
                if (sources.providedByNonItem.getBoolean(i) || rem.m_41619_()) continue;
                outputList.add((Object)rem);
            }
            outputBuffer.add(new OutputBuffer((NonNullList<ItemStack>)outputList, patternId));
            ctx.markMasterDirty();
        }
        return outputBuffer;
    }

    private void outputStack(State state, ItemStack output, int patternId, boolean isMainOutput) {
        if (!this.isRecipeIngredient(state, output, patternId) && ((output = Utils.insertStackIntoInventory(state.output, output, false)).m_41619_() || output.m_41613_() <= 0)) {
            return;
        }
        if (isMainOutput) {
            this.tryInsertOnto(state, 18 + patternId, output);
        } else {
            int i;
            boolean inserted = false;
            for (i = 0; i < state.inventory.getSlots(); ++i) {
                if (!this.tryInsertOnto(state, i, output)) continue;
                inserted = true;
                break;
            }
            if (!inserted) {
                for (i = 0; i < state.inventory.getSlots(); ++i) {
                    if (!state.inventory.getStackInSlot(i).m_41619_()) continue;
                    state.inventory.setStackInSlot(i, output.m_41777_());
                }
            }
        }
    }

    public boolean consumeIngredients(State state, List<RecipeQuery> queries, ArrayList<ItemStack> itemStacks, boolean doConsume, @Nullable RecipeInputSources sources) {
        if (!doConsume) {
            ArrayList<ItemStack> dupeList = new ArrayList<ItemStack>(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                dupeList.add(itemStack.m_41777_());
            }
            itemStacks = dupeList;
        }
        List<FluidStack> tankFluids = Arrays.stream(state.tanks).map(tank -> doConsume ? tank.getFluid() : tank.getFluid().copy()).toList();
        for (int i = 0; i < queries.size(); ++i) {
            RecipeQuery recipeQuery = queries.get(i);
            int querySize = recipeQuery.getItemCount();
            if (recipeQuery.isFluid()) {
                if (this.consumeFluid(tankFluids, i, recipeQuery, sources)) continue;
                querySize = 1;
            }
            for (ItemStack itemStack : itemStacks) {
                querySize -= this.consumeItem(querySize, i, itemStack, recipeQuery, sources);
            }
            if (querySize <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isRecipeIngredient(State state, ItemStack stack, int slot) {
        if (stack.m_41619_()) {
            return false;
        }
        if (slot - 1 < state.patterns.length || state.recursiveIngredients) {
            int p;
            int n = p = state.recursiveIngredients ? 0 : slot;
            while (p < state.patterns.length) {
                CrafterPatternInventory pattern = state.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (((ItemStack)pattern.inv.get(i)).m_41619_() || !ItemStack.m_41656_((ItemStack)((ItemStack)pattern.inv.get(i)), (ItemStack)stack)) continue;
                    return true;
                }
                ++p;
            }
        }
        return false;
    }

    private boolean consumeFluid(List<FluidStack> tankFluids, int slot, RecipeQuery query, @Nullable RecipeInputSources sources) {
        for (FluidStack tankFluid : tankFluids) {
            if (!query.matchesFluid(tankFluid)) continue;
            tankFluid.shrink(query.getFluidSize());
            if (sources != null) {
                sources.providedByNonItem.set(slot, true);
            }
            return true;
        }
        return false;
    }

    private int consumeItem(int maxConsume, int slot, ItemStack next, RecipeQuery query, @Nullable RecipeInputSources sources) {
        if (maxConsume <= 0 || next.m_41619_() || !query.matchesIgnoringSize(next)) {
            return 0;
        }
        int taken = Math.min(maxConsume, next.m_41613_());
        ItemStack forGrid = next.m_41620_(taken);
        if (sources != null) {
            sources.gridItems.set(slot, forGrid);
        }
        return taken;
    }

    private boolean tryInsertOnto(State state, int slot, ItemStack toAdd) {
        if (!this.canInsertOnto(state, slot, toAdd)) {
            return false;
        }
        ItemStack present = state.inventory.getStackInSlot(slot);
        if (present.m_41619_()) {
            state.inventory.setStackInSlot(slot, toAdd);
        } else {
            present.m_41769_(toAdd.m_41613_());
        }
        return true;
    }

    public boolean canInsertOnto(State state, int slot, ItemStack output) {
        ItemStack existing = state.inventory.getStackInSlot(slot);
        if (existing.m_41619_()) {
            return true;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)existing)) {
            return false;
        }
        return existing.m_41613_() + output.m_41613_() <= existing.m_41741_();
    }

    public boolean canOutput(State state, ItemStack output, int iPattern) {
        return this.canInsertOnto(state, 18 + iPattern, output);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && ITEM_INPUT.equals(position)) {
            return ctx.getState().itemInput.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_INPUT.equals(position)) {
            return ctx.getState().fluidInput.cast(ctx);
        }
        if (cap == ForgeCapabilities.ENERGY && ENERGY_INPUT.equals(position)) {
            return ctx.getState().energyInput.cast(ctx);
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return AssemblerShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState {
        public final FluidTank[] tanks = (FluidTank[])IntStream.range(0, 3).mapToObj($ -> new FluidTank(8000)).toArray(FluidTank[]::new);
        public final SlotwiseItemHandler inventory;
        public final CrafterPatternInventory[] patterns = (CrafterPatternInventory[])IntStream.range(0, 3).mapToObj($ -> new CrafterPatternInventory()).toArray(CrafterPatternInventory[]::new);
        public boolean recursiveIngredients = false;
        public final MutableEnergyStorage energy = new MutableEnergyStorage(32000);
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final CapabilityReference<IItemHandler> output;
        private final StoredCapability<IItemHandler> itemInput;
        private final StoredCapability<IFluidHandler> fluidInput;
        private final StoredCapability<IEnergyStorage> energyInput = new StoredCapability<MutableEnergyStorage>(this.energy);

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, new BlockPos(1, 1, -1), RelativeBlockFace.FRONT);
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.NO_CONSTRAINT, 21)), ctx.getMarkDirtyRunnable());
            this.itemInput = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, true, false));
            this.fluidInput = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler((IFluidTank[])this.tanks, false, true, ctx.getMarkDirtyRunnable()));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            ListTag tanks = new ListTag();
            for (FluidTank tank : this.tanks) {
                tanks.add((Object)tank.writeToNBT(new CompoundTag()));
            }
            ListTag patterns = new ListTag();
            for (CrafterPatternInventory pattern : this.patterns) {
                patterns.add((Object)pattern.writeToNBT());
            }
            nbt.m_128365_("tanks", (Tag)tanks);
            nbt.m_128365_("patterns", (Tag)patterns);
            nbt.m_128379_("recursiveIngredients", this.recursiveIngredients);
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128365_("energy", this.energy.serializeNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            ListTag tanks = nbt.m_128437_("tanks", 10);
            for (int i = 0; i < 3; ++i) {
                this.tanks[i].readFromNBT(tanks.m_128728_(i));
            }
            ListTag patterns = nbt.m_128437_("patterns", 9);
            for (int i = 0; i < 3; ++i) {
                this.patterns[i].readFromNBT(patterns.m_128744_(i));
            }
            this.recursiveIngredients = nbt.m_128471_("recursiveIngredients");
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
        }

        public IItemHandler getInventory() {
            return this.inventory;
        }
    }

    private record OutputBuffer(NonNullList<ItemStack> results, int id) {
    }

    private record RecipeInputSources(List<ItemStack> gridItems, BooleanList providedByNonItem) {
        public RecipeInputSources(CrafterPatternInventory pattern) {
            this(new ArrayList<ItemStack>((Collection<ItemStack>)pattern.inv), (BooleanList)new BooleanArrayList(new boolean[9]));
        }
    }
}

