/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.EnergyHelpers;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceEnergy
extends PartTypeInterfacePositionedAddon<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
    public PartTypeInterfaceEnergy(String name) {
        super(name);
    }

    @Override
    public Capability<IEnergyNetwork> getNetworkCapability() {
        return Capabilities.NETWORK_ENERGY;
    }

    @Override
    public Capability<IEnergyStorage> getTargetCapability() {
        return ForgeCapabilities.ENERGY;
    }

    @Override
    public LazyOptional<IEnergyStorage> getTargetCapabilityInstance(PartPos pos) {
        return EnergyHelpers.getEnergyStorage((PartPos)pos);
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceEnergyBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<IEnergyNetwork, IEnergyStorage, PartTypeInterfaceEnergy, State> {
        @Override
        public Capability<IEnergyStorage> getTargetCapability() {
            return ForgeCapabilities.ENERGY;
        }

        @Override
        public IEnergyStorage getCapabilityInstance() {
            return new EnergyStorage(this);
        }
    }

    public static class EnergyStorage
    implements IEnergyStorage {
        private final IPartTypeInterfacePositionedAddon.IState<IEnergyNetwork, IEnergyStorage, ?, ?> state;

        public EnergyStorage(IPartTypeInterfacePositionedAddon.IState<IEnergyNetwork, IEnergyStorage, ?, ?> state) {
            this.state = state;
        }

        protected IEnergyStorage getEnergyStorage() {
            return (IEnergyStorage)this.state.getPositionedAddonsNetwork().getChannelExternal(ForgeCapabilities.ENERGY, this.state.getChannel());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().receiveEnergy(maxReceive, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().extractEnergy(maxExtract, simulate);
            this.state.enablePosition();
            return ret;
        }

        public int getEnergyStored() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().getEnergyStored();
            this.state.enablePosition();
            return ret;
        }

        public int getMaxEnergyStored() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getEnergyStorage().getMaxEnergyStored();
            this.state.enablePosition();
            return ret;
        }

        public boolean canExtract() {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getEnergyStorage().canExtract();
            this.state.enablePosition();
            return ret;
        }

        public boolean canReceive() {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getEnergyStorage().canReceive();
            this.state.enablePosition();
            return ret;
        }
    }
}

