/*
 * Decompiled with CFR 0.152.
 */
package jeresources.registry;

import java.util.HashSet;
import java.util.Set;
import jeresources.entry.EnchantmentEntry;
import jeresources.platform.Services;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentRegistry {
    private Set<EnchantmentEntry> enchantments = new HashSet<EnchantmentEntry>();
    private static EnchantmentRegistry instance;

    public static EnchantmentRegistry getInstance() {
        if (instance == null) {
            instance = new EnchantmentRegistry();
            return instance;
        }
        return instance;
    }

    public EnchantmentRegistry() {
        for (Enchantment enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null) continue;
            this.enchantments.add(new EnchantmentEntry(enchantment));
        }
    }

    public Set<EnchantmentEntry> getEnchantments(ItemStack itemStack) {
        HashSet<EnchantmentEntry> set = new HashSet<EnchantmentEntry>();
        for (EnchantmentEntry enchantmentEntry : this.enchantments) {
            Enchantment enchantment = enchantmentEntry.getEnchantment();
            if (itemStack.m_41720_() == Items.f_42517_ && Services.PLATFORM.isAllowedOnBooks(enchantment)) {
                set.add(enchantmentEntry);
                continue;
            }
            if (!enchantment.m_6081_(itemStack) || !EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)itemStack).keySet(), (Enchantment)enchantment)) continue;
            set.add(enchantmentEntry);
        }
        return set;
    }

    private void excludeFormRegistry(Enchantment enchantment) {
        this.enchantments.removeIf(enchantmentEntry -> enchantmentEntry.getEnchantment().m_44704_().toString().equals(enchantment.m_44704_()));
    }

    private void excludeFormRegistry(String sEnchantment) {
        for (Enchantment enchantment : EnchantmentRegistry.getEnchants()) {
            if (enchantment == null || !enchantment.m_44704_().toLowerCase().contains(sEnchantment.toLowerCase())) continue;
            this.excludeFormRegistry(enchantment);
        }
    }

    public void removeAll(String[] excludedEnchants) {
        for (String enchant : excludedEnchants) {
            this.excludeFormRegistry(enchant);
        }
    }

    private static Iterable<Enchantment> getEnchants() {
        return BuiltInRegistries.f_256876_;
    }
}

