/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.message;

import com.github.L_Ender.cataclysm.capabilities.HoldAttackCapability;
import com.github.L_Ender.cataclysm.init.ModCapabilities;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class MessageHoldEntity {
    private final int entityID;
    private final boolean hold;
    private int holder = 0;
    private Vec3 PosVector;

    public MessageHoldEntity(int id, HoldAttackCapability.IHoldAttackCapability cap) {
        this.entityID = id;
        this.hold = cap.getHold();
        this.PosVector = cap.getPosVector();
        if (cap.getHolder() != null) {
            this.holder = cap.getHolder().m_19879_();
        }
    }

    public MessageHoldEntity(Entity entity, HoldAttackCapability.IHoldAttackCapability cap) {
        this(entity.m_19879_(), cap);
    }

    public MessageHoldEntity(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.hold = buf.readBoolean();
        this.holder = buf.readInt();
        this.PosVector = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.hold);
        buf.writeInt(this.holder);
        buf.writeDouble(this.PosVector.f_82479_);
        buf.writeDouble(this.PosVector.f_82480_);
        buf.writeDouble(this.PosVector.f_82481_);
    }

    public static class Handler {
        public static boolean handle(MessageHoldEntity message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                if (entity instanceof LivingEntity) {
                    entity.getCapability(ModCapabilities.HOLD_ATTACK_CAPABILITY).ifPresent(cap -> {
                        LivingEntity holder;
                        LivingEntity livingEntity = holder = message.holder != 0 ? (LivingEntity)Minecraft.m_91087_().f_91073_.m_6815_(message.holder) : null;
                        if (entity instanceof Player) {
                            cap.setHold(message.hold, holder, message.PosVector);
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

