/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.math;

import java.util.List;
import java.util.function.UnaryOperator;

public abstract class Polynomial<T extends Number>
implements UnaryOperator<T> {
    private String stringValue = null;

    protected Polynomial() {
    }

    public abstract List<T> coefficients();

    public String toString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        List<T> coefficients = this.coefficients();
        if (coefficients.isEmpty()) {
            this.stringValue = "0";
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < coefficients.size(); ++i) {
                if (((Number)coefficients.get(i)).doubleValue() == 0.0) continue;
                if (!first && ((Number)coefficients.get(i)).doubleValue() >= 0.0) {
                    sb.append("+");
                }
                first = false;
                int exp = coefficients.size() - i - 1;
                if (exp == 0) {
                    sb.append(((Number)this.coefficients().get(i)).toString());
                    continue;
                }
                if (((Number)coefficients.get(i)).doubleValue() != 1.0) {
                    sb.append(((Number)coefficients.get(i)).toString());
                }
                sb.append("x");
                if (exp == 1) continue;
                sb.append(Integer.toString(exp).replace('-', '\u207b').replace('0', '\u2070').replace('1', '\u00b9').replace('2', '\u00b2').replace('3', '\u00b3').replace('4', '\u2074').replace('5', '\u2075').replace('6', '\u2076').replace('7', '\u2077').replace('8', '\u2078').replace('9', '\u2079'));
            }
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }
}

