/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.annotation.processor.misc;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.moddingx.libx.annotation.processor.Classes;
import org.moddingx.libx.annotation.processor.Processor;

public class ConfigProcessor
extends Processor {
    private Set<TypeMirror> wrapperTypes;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.wrapperTypes = Set.of(this.forClass(Boolean.class), this.forClass(Byte.class), this.forClass(Character.class), this.forClass(Short.class), this.forClass(Integer.class), this.forClass(Long.class), this.forClass(Float.class), this.forClass(Double.class));
    }

    @Override
    public Class<?>[] getTypes() {
        return new Class[0];
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> set = new HashSet<String>(super.getSupportedAnnotationTypes());
        set.add(Classes.sourceName("org.moddingx.libx.config.Config"));
        return set;
    }

    @Override
    public void run(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.typeElement("org.moddingx.libx.config.Config"))) {
            DeclaredType declared;
            List<? extends TypeMirror> parameters;
            TypeMirror typeMirror;
            if (this.isSuppressed(element, "config")) continue;
            if (element.getKind() != ElementKind.FIELD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.FINAL)) {
                this.messager().printMessage(Diagnostic.Kind.ERROR, "Only public static non-final fields can be annotated with @Config", element);
                continue;
            }
            TypeMirror firstGeneric = this.forClass(String.class);
            if (element.asType().getKind() == TypeKind.DECLARED && (typeMirror = element.asType()) instanceof DeclaredType && !(parameters = (declared = (DeclaredType)typeMirror).getTypeArguments()).isEmpty()) {
                firstGeneric = parameters.get(0);
            }
            for (TypeMirror wrapper : this.wrapperTypes) {
                if (!this.sameErasure(element.asType(), wrapper)) continue;
                this.messager().printMessage(Diagnostic.Kind.WARNING, "Unchecked @Config: Config should use primitive instead of wrapper type.", element);
                break;
            }
            if (!this.sameErasure(this.forClass(Map.class), element.asType()) || this.sameErasure(firstGeneric, this.forClass(String.class)) || this.isSuppressed(element, "unchecked")) continue;
            this.messager().printMessage(Diagnostic.Kind.WARNING, "Unchecked @Config: Map required keys of type String.", element);
        }
    }
}

