/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import org.moddingx.libx.impl.sandbox.layer.NoiseLayerSelector;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.generator.BiomeLayer;

public class LayeredBiomeSource
extends BiomeSource {
    public static final Codec<LayeredBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206279_(SandBox.BIOME_LAYER, BiomeLayer.DIRECT_CODEC).fieldOf("layers").forGetter(biomes -> biomes.layers)).apply((Applicative)instance, LayeredBiomeSource::new));
    private final HolderSet<BiomeLayer> layers;
    private NoiseLayerSelector sel;
    private MultiNoiseBiomeSource[] sources;
    private Climate.ParameterPoint[] ranges;

    public LayeredBiomeSource(HolderSet<BiomeLayer> layers) {
        this.layers = layers;
    }

    @Nonnull
    protected Stream<Holder<Biome>> m_274359_() {
        return this.layers.m_203614_().flatMap(layer -> ((BiomeLayer)layer.m_203334_()).biomes().m_186850_().stream()).map(Pair::getSecond).distinct();
    }

    public void init(long seed) {
        List<BiomeLayer> layersInOrder = this.layers.m_203614_().map(Holder::m_203334_).toList();
        this.sel = new NoiseLayerSelector(layersInOrder.stream().map(BiomeLayer::density).toList(), RandomSource.m_216335_((long)(seed * -6524552231151932243L)));
        this.ranges = (Climate.ParameterPoint[])layersInOrder.stream().map(BiomeLayer::range).toArray(Climate.ParameterPoint[]::new);
        this.sources = (MultiNoiseBiomeSource[])layersInOrder.stream().map(layer -> MultiNoiseBiomeSource.m_274596_(layer.biomes())).toArray(MultiNoiseBiomeSource[]::new);
    }

    @Nonnull
    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    private int getNoiseLayer(int x, int y, int z, @Nonnull Climate.TargetPoint target) {
        int i;
        if (this.sel == null) {
            throw new IllegalStateException("Random layer selector not initialised.");
        }
        if (this.sources.length == 1) {
            return 0;
        }
        int matchAmount = 0;
        int lastMatch = 0;
        boolean[] matches = new boolean[this.sources.length];
        for (i = 0; i < this.sources.length; ++i) {
            if (!LayeredBiomeSource.isInRange(this.ranges[i], target)) continue;
            ++matchAmount;
            matches[i] = true;
            lastMatch = i;
        }
        if (matchAmount == 1) {
            return lastMatch;
        }
        if (matchAmount == 0) {
            for (i = 0; i < this.sources.length; ++i) {
                matches[i] = true;
            }
        }
        return this.sel.sample(x, y, z, matches);
    }

    @Nonnull
    public Holder<Biome> m_203407_(int x, int y, int z, @Nonnull Climate.Sampler sampler) {
        Climate.TargetPoint target = sampler.m_183445_(x, y, z);
        return this.sources[this.getNoiseLayer(x, y, z, target)].m_204269_(target);
    }

    private static boolean isInRange(Climate.ParameterPoint point, Climate.TargetPoint target) {
        if (point.f_186863_().m_186825_(target.f_187003_()) != 0L) {
            return false;
        }
        if (point.f_186864_().m_186825_(target.f_187004_()) != 0L) {
            return false;
        }
        if (point.f_186865_().m_186825_(target.f_187005_()) != 0L) {
            return false;
        }
        if (point.f_186866_().m_186825_(target.f_187006_()) != 0L) {
            return false;
        }
        if (point.f_186867_().m_186825_(target.f_187007_()) != 0L) {
            return false;
        }
        return point.f_186868_().m_186825_(target.f_187008_()) == 0L;
    }

    public void m_207301_(List<String> lines, BlockPos pos, Climate.Sampler sampler) {
        Climate.TargetPoint target = sampler.m_183445_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()));
        float continentalness = Climate.m_186796_((long)target.f_187005_());
        float erosion = Climate.m_186796_((long)target.f_187006_());
        float temperature = Climate.m_186796_((long)target.f_187003_());
        float humidity = Climate.m_186796_((long)target.f_187004_());
        float weirdness = Climate.m_186796_((long)target.f_187008_());
        double peaks = NoiseRouterData.m_224435_((float)weirdness);
        OverworldBiomeBuilder builder = new OverworldBiomeBuilder();
        StringBuilder sb = new StringBuilder("Biome builder");
        sb.append(" PV: ").append(OverworldBiomeBuilder.m_187155_((double)peaks));
        sb.append(" C: ").append(builder.m_187189_((double)continentalness));
        sb.append(" E: ").append(builder.m_187209_((double)erosion));
        sb.append(" T: ").append(builder.m_187220_((double)temperature));
        sb.append(" H: ").append(builder.m_187231_((double)humidity));
        lines.add(sb.toString());
        if (this.sel != null) {
            sb = new StringBuilder("Layer selector");
            sb.append(" L: ").append(this.getNoiseLayer(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), target));
            sb.append(" M: ").append(this.sources.length);
            lines.add(sb.toString());
        }
    }
}

