/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.ModelIndustrialAlarm;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.tileentity.ModelTileEntityRenderer;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderIndustrialAlarm
extends ModelTileEntityRenderer<TileEntityIndustrialAlarm, ModelIndustrialAlarm> {
    private static final float ROTATE_SPEED = 10.0f;

    public RenderIndustrialAlarm(BlockEntityRendererProvider.Context context) {
        super(context, ModelIndustrialAlarm::new);
    }

    @Override
    protected void render(final TileEntityIndustrialAlarm tile, float partialTicks, PoseStack matrix, MultiBufferSource renderer, int light, final int overlayLight, ProfilerFiller profiler) {
        RenderTickHandler.addTransparentRenderer(((ModelIndustrialAlarm)this.model).getRenderType(), new RenderTickHandler.LazyRender(){

            @Override
            public void render(Camera camera, VertexConsumer buffer, PoseStack poseStack, int renderTick, float partialTick, ProfilerFiller profiler) {
                float rot = ((float)renderTick + partialTick) * 10.0f % 360.0f;
                Vec3 renderPos = Vec3.m_82539_((Vec3i)tile.m_58899_());
                poseStack.m_85836_();
                poseStack.m_85837_(renderPos.f_82479_, renderPos.f_82480_, renderPos.f_82481_);
                switch (tile.getDirection()) {
                    case DOWN: {
                        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                        break;
                    }
                    case NORTH: {
                        poseStack.m_85837_(0.0, 0.5, 0.5);
                        poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
                        break;
                    }
                    case SOUTH: {
                        poseStack.m_85837_(0.0, 0.5, -0.5);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        break;
                    }
                    case EAST: {
                        poseStack.m_85837_(-0.5, 0.5, 0.0);
                        poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
                        break;
                    }
                    case WEST: {
                        poseStack.m_85837_(0.5, 0.5, 0.0);
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    }
                }
                ((ModelIndustrialAlarm)RenderIndustrialAlarm.this.model).render(poseStack, buffer, 0xF000F0, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f, rot);
                poseStack.m_85849_();
            }

            @Override
            public Vec3 getCenterPos(float partialTick) {
                return Vec3.m_82512_((Vec3i)tile.m_58899_());
            }

            @Override
            public String getProfilerSection() {
                return "industrialAlarm";
            }
        });
    }

    @Override
    protected String getProfilerSection() {
        return "industrialAlarm";
    }

    public boolean shouldRender(TileEntityIndustrialAlarm tile, Vec3 camera) {
        return tile.getActive() && super.m_142756_((BlockEntity)tile, camera);
    }
}

