/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.mysticalagriculture.api.util.ExperienceCapsuleUtils;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExperienceCapsuleItem
extends BaseItem {
    public ExperienceCapsuleItem() {
        super(p -> p.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int experience = ExperienceCapsuleUtils.getExperience(stack);
        if (player.m_6047_()) {
            if (experience > 0) {
                int xpToGive = Math.min(experience, ExperienceCapsuleItem.getExperienceToGive(player));
                xpToGive -= ExperienceCapsuleUtils.removeExperienceFromCapsule(stack, xpToGive);
                ExperienceCapsuleItem.giveExperiencePoints(player, xpToGive);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
        } else if (experience < 1200 && player.f_36079_ > 0) {
            int xpToTake = Math.min(1200 - experience, ExperienceCapsuleItem.getExperienceToTake(player));
            xpToTake -= ExperienceCapsuleUtils.addExperienceToCapsule(stack, xpToTake);
            ExperienceCapsuleItem.giveExperiencePoints(player, -xpToTake);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        int experience = ExperienceCapsuleUtils.getExperience(stack);
        tooltip.add((Component)ModTooltips.EXPERIENCE_CAPSULE.args(new Object[]{Formatting.number((Object)experience), Formatting.number((Object)1200)}).build());
    }

    public static ItemPropertyFunction getFillPropertyGetter() {
        return (stack, _level, _entity, _unused) -> {
            int experience = ExperienceCapsuleUtils.getExperience(stack);
            if (experience > 0) {
                double level = (double)experience / 1200.0;
                return (int)(level * 10.0);
            }
            return 0.0f;
        };
    }

    private static int getExperienceToGive(Player player) {
        int xpNeeded = player.m_36323_();
        int extraXp = Math.round((float)xpNeeded * player.f_36080_);
        return xpNeeded - extraXp;
    }

    private static int getExperienceToTake(Player player) {
        if (player.f_36080_ > 0.0f) {
            int xpNeeded = player.m_36323_();
            return Math.round((float)xpNeeded * player.f_36080_);
        }
        --player.f_36078_;
        int xpNeeded = player.m_36323_();
        ++player.f_36078_;
        return xpNeeded;
    }

    private static void giveExperiencePoints(Player player, int points) {
        player.f_36080_ += (float)points / (float)player.m_36323_();
        player.f_36079_ = Mth.m_14045_((int)(player.f_36079_ + points), (int)0, (int)Integer.MAX_VALUE);
        while (player.f_36080_ < 0.0f) {
            float f = player.f_36080_ * (float)player.m_36323_();
            if (player.f_36078_ > 0) {
                ExperienceCapsuleItem.giveExperienceLevels(player, -1);
                player.f_36080_ = 1.0f + f / (float)player.m_36323_();
                continue;
            }
            ExperienceCapsuleItem.giveExperienceLevels(player, -1);
            player.f_36080_ = 0.0f;
        }
        while (player.f_36080_ >= 1.0f) {
            player.f_36080_ = (player.f_36080_ - 1.0f) * (float)player.m_36323_();
            ExperienceCapsuleItem.giveExperienceLevels(player, 1);
            player.f_36080_ /= (float)player.m_36323_();
        }
    }

    private static void giveExperienceLevels(Player player, int levels) {
        player.f_36078_ += levels;
        if (player.f_36078_ < 0) {
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            player.f_36079_ = 0;
        }
    }
}

