/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.datagen;

import mythicbotany.alfheim.datagen.AlfheimFeatures;
import mythicbotany.alfheim.worldgen.placement.AlfheimGroundModifier;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.sandbox.FeatureProviderBase;
import org.moddingx.libx.sandbox.placement.HeightPlacementFilter;

public class AlfheimPlacements
extends FeatureProviderBase {
    private final AlfheimFeatures features;
    private final FeatureProviderBase.PlacementModifiers trees;
    public final Holder<PlacedFeature> metamorphicForestStone;
    public final Holder<PlacedFeature> metamorphicMountainStone;
    public final Holder<PlacedFeature> metamorphicFungalStone;
    public final Holder<PlacedFeature> metamorphicSwampStone;
    public final Holder<PlacedFeature> metamorphicDesertStone;
    public final Holder<PlacedFeature> metamorphicTaigaStone;
    public final Holder<PlacedFeature> metamorphicMesaStone;
    public final Holder<PlacedFeature> looseDreamwoodTrees;
    public final Holder<PlacedFeature> denseDreamwoodTrees;
    public final Holder<PlacedFeature> motifFlowers;
    public final Holder<PlacedFeature> alfheimGrass;
    public final Holder<PlacedFeature> manaCrystals;
    public final Holder<PlacedFeature> abandonedApothecaries;
    public final Holder<PlacedFeature> wheatFields;
    public final Holder<PlacedFeature> elementiumOre;
    public final Holder<PlacedFeature> dragonstoneOre;
    public final Holder<PlacedFeature> goldOre;
    public final Holder<PlacedFeature> extraGoldOre;

    public AlfheimPlacements(DatagenContext ctx) {
        super(ctx);
        this.features = (AlfheimFeatures)this.context.findRegistryProvider(AlfheimFeatures.class);
        this.trees = (FeatureProviderBase.PlacementModifiers)this.modifiers().spread().waterDepth(0).heightmap(Heightmap.Types.OCEAN_FLOOR).validGround(Blocks.f_50746_).biomeFilter().build();
        this.metamorphicForestStone = this.metamorphicStone(this.features.metamorphicForestStone);
        this.metamorphicMountainStone = this.metamorphicStone(this.features.metamorphicMountainStone);
        this.metamorphicFungalStone = this.metamorphicStone(this.features.metamorphicFungalStone);
        this.metamorphicSwampStone = this.metamorphicStone(this.features.metamorphicSwampStone);
        this.metamorphicDesertStone = this.metamorphicStone(this.features.metamorphicDesertStone);
        this.metamorphicTaigaStone = this.metamorphicStone(this.features.metamorphicTaigaStone);
        this.metamorphicMesaStone = this.metamorphicStone(this.features.metamorphicMesaStone);
        this.looseDreamwoodTrees = (Holder)this.placement(this.features.dreamwoodTrees).rarity(10).add(this.trees).build();
        this.denseDreamwoodTrees = (Holder)this.placement(this.features.dreamwoodTrees).countExtra(2, 0.1f, 1).add(this.trees).build();
        this.motifFlowers = (Holder)this.placement(this.features.motifFlowers).count(3).spread().add(new PlacementModifier[]{AlfheimGroundModifier.INSTANCE}).biomeFilter().build();
        this.alfheimGrass = (Holder)this.placement(this.features.alfheimGrass).count(15).spread().add(new PlacementModifier[]{AlfheimGroundModifier.INSTANCE}).biomeFilter().build();
        this.manaCrystals = (Holder)this.placement(this.features.manaCrystals).count(1, 4).rarity(2).spread().add(new PlacementModifier[]{AlfheimGroundModifier.INSTANCE}).add(new PlacementModifier[]{new HeightPlacementFilter(VerticalAnchor.f_158915_, VerticalAnchor.m_158922_((int)84))}).biomeFilter().build();
        this.abandonedApothecaries = (Holder)this.placement(this.features.abandonedApothecaries).count(1, 3).rarity(2).spread().add(new PlacementModifier[]{AlfheimGroundModifier.INSTANCE}).biomeFilter().build();
        this.wheatFields = (Holder)this.placement(this.features.wheatFields).count(3).spread().biomeFilter().build();
        this.elementiumOre = (Holder)this.placement(this.features.elementiumOre).add(this.ore(5, VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)70))).build();
        this.dragonstoneOre = (Holder)this.placement(this.features.dragonstoneOre).add(this.ore(1, VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)16))).build();
        this.goldOre = (Holder)this.placement(this.features.goldOre).add(this.ore(2, VerticalAnchor.m_158921_(), VerticalAnchor.m_158922_((int)32))).build();
        this.extraGoldOre = (Holder)this.placement(this.features.goldOre).add(this.ore(5, VerticalAnchor.m_158930_((int)16), VerticalAnchor.m_158922_((int)80))).build();
    }

    private Holder<PlacedFeature> metamorphicStone(Holder<ConfiguredFeature<?, ?>> feature) {
        return (Holder)this.placement(feature).spread().height(VerticalAnchor.m_158921_(), VerticalAnchor.m_158929_()).build();
    }

    private FeatureProviderBase.PlacementModifiers ore(int count, VerticalAnchor min, VerticalAnchor max) {
        FeatureProviderBase.ModifierBuilder builder = this.modifiers();
        if (count > 1) {
            builder.count(count);
        }
        return (FeatureProviderBase.PlacementModifiers)builder.spread().heightTriangle(min, max).build();
    }
}

