/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;
import vazkii.botania.client.fx.WispParticleData;

public record InfusionMessage(BlockPos pos, double progress, int fromColor, int toColor) {

    public static class Handler
    implements PacketHandler<InfusionMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(InfusionMessage msg, Supplier<NetworkEvent.Context> ctx) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return true;
            }
            int ticks = (int)(100.0 * msg.progress());
            int totalSpiritCount = 3;
            double tickIncrement = 360.0 / (double)totalSpiritCount;
            int speed = 5;
            double wticks = (double)(ticks * speed) - tickIncrement;
            double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
            for (int i = 0; i < totalSpiritCount; ++i) {
                double x = (double)msg.pos().m_123341_() + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                double y = (double)msg.pos().m_123342_() + 0.25 + Math.abs(r) * 0.7;
                double z = (double)msg.pos().m_123343_() + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                wticks += tickIncrement;
                float fromR = (float)(msg.fromColor() >> 16 & 0xFF) / 255.0f;
                float fromG = (float)(msg.fromColor() >> 8 & 0xFF) / 255.0f;
                float fromB = (float)(msg.fromColor() & 0xFF) / 255.0f;
                float toR = (float)(msg.toColor() >> 16 & 0xFF) / 255.0f;
                float toG = (float)(msg.toColor() >> 8 & 0xFF) / 255.0f;
                float toB = (float)(msg.toColor() & 0xFF) / 255.0f;
                float[] colorsfx = new float[]{fromR + (toR - fromR) * (float)msg.progress(), fromG + (toG - fromG) * (float)msg.progress(), fromB + (toB - fromB) * (float)msg.progress()};
                WispParticleData data = WispParticleData.wisp((float)0.85f, (float)colorsfx[0], (float)colorsfx[1], (float)colorsfx[2], (float)0.25f);
                level.m_7106_((ParticleOptions)data, x, y, z, 0.0, (double)((float)(-g * 0.05)), 0.0);
                data = WispParticleData.wisp((float)((float)Math.random() * 0.1f + 0.1f), (float)colorsfx[0], (float)colorsfx[1], (float)colorsfx[2], (float)0.9f);
                level.m_7106_((ParticleOptions)data, x, y, z, (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f), (double)((float)(Math.random() - 0.5) * 0.05f));
                if (ticks != 100) continue;
                for (int j = 0; j < 15; ++j) {
                    data = WispParticleData.wisp((float)((float)Math.random() * 0.15f + 0.15f), (float)colorsfx[0], (float)colorsfx[1], (float)colorsfx[2]);
                    level.m_7106_((ParticleOptions)data, (double)msg.pos().m_123341_() + 0.5, (double)msg.pos().m_123342_() + 0.5, (double)msg.pos().m_123343_() + 0.5, (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f), (double)((float)(Math.random() - 0.5) * 0.125f));
                }
            }
            return true;
        }
    }

    public static class Serializer
    implements PacketSerializer<InfusionMessage> {
        public Class<InfusionMessage> messageClass() {
            return InfusionMessage.class;
        }

        public void encode(InfusionMessage msg, FriendlyByteBuf buffer) {
            buffer.m_130064_(msg.pos());
            buffer.writeDouble(msg.progress());
            buffer.writeInt(msg.fromColor());
            buffer.writeInt(msg.toColor());
        }

        public InfusionMessage decode(FriendlyByteBuf buffer) {
            BlockPos pos = buffer.m_130135_();
            double progress = buffer.readDouble();
            int fromColor = buffer.readInt();
            int toColor = buffer.readInt();
            return new InfusionMessage(pos, progress, fromColor, toColor);
        }
    }
}

