/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BlockEntitySnowCreator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int snowmanCount;

    public BlockEntitySnowCreator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SNOW_CREATOR, pos, state);
    }

    public int getRange() {
        return this.redstonePower * 2;
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        this.sendToClients();
    }

    @Override
    public void tick() {
        int range = this.getRange();
        if (range <= 0) {
            return;
        }
        int toDrain = 300;
        if (!this.canUseRightNow(toDrain)) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 10L != 0L) {
                return;
            }
            for (int i = 0; i < 10; ++i) {
                double angle = (double)this.f_58857_.f_46441_.m_188501_() * Math.PI * 2.0;
                BlockPos pos = this.f_58858_.m_7918_(Mth.m_14107_((double)(Math.cos(angle) * (double)range * (double)this.f_58857_.f_46441_.m_188501_())), 0, Mth.m_14107_((double)(Math.sin(angle) * (double)range * (double)this.f_58857_.f_46441_.m_188501_())));
                BlockPos down = (pos = this.f_58857_.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos)).m_7495_();
                Fluid fluid = this.f_58857_.m_6425_(down).m_76152_();
                if (fluid == Fluids.f_76193_) {
                    if (this.f_58857_.m_8055_(down).m_247087_()) {
                        this.f_58857_.m_46597_(down, Blocks.f_50126_.m_49966_());
                    }
                } else {
                    if (!Blocks.f_50125_.m_49966_().m_60710_((LevelReader)this.f_58857_, pos) || this.f_58857_.m_8055_(pos).m_60734_() == Blocks.f_50125_ || !this.f_58857_.m_8055_(pos).m_247087_()) continue;
                    this.f_58857_.m_46597_(pos, Blocks.f_50125_.m_49966_());
                    if (this.snowmanCount < range / 2 && this.f_58857_.f_46441_.m_188501_() >= 0.995f) {
                        ++this.snowmanCount;
                        SnowGolem golem = new SnowGolem(EntityType.f_20528_, this.f_58857_);
                        golem.m_6034_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
                        this.f_58857_.m_7967_((Entity)golem);
                    }
                }
                BlockPos auraPos = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 30, this.f_58858_);
                IAuraChunk.getAuraChunk(this.f_58857_, auraPos).drainAura(auraPos, toDrain);
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.SNOW_CREATOR, new int[0]));
                break;
            }
        } else {
            if (this.f_58857_.m_46467_() % 30L != 0L) {
                return;
            }
            for (int i = range * 4; i >= 0; --i) {
                double angle = (double)this.f_58857_.f_46441_.m_188501_() * Math.PI * 2.0;
                BlockPos pos = this.f_58858_.m_7918_(Mth.m_14107_((double)(Math.cos(angle) * (double)range * (double)this.f_58857_.f_46441_.m_188501_())), Mth.m_216271_((RandomSource)this.f_58857_.f_46441_, (int)(range / 2), (int)range), Mth.m_14107_((double)(Math.sin(angle) * (double)range * (double)this.f_58857_.f_46441_.m_188501_())));
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + this.f_58857_.f_46441_.m_188501_(), pos.m_123342_() + 1, (float)pos.m_123343_() + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188583_() * 0.05, 0.0, this.f_58857_.f_46441_.m_188583_() * 0.05, 14412287, 1.0f + this.f_58857_.f_46441_.m_188501_() * 1.5f, 10 * range, 0.05f + this.f_58857_.f_46441_.m_188501_() * 0.05f, true, true);
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.m_128405_("snowman_count", this.snowmanCount);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.snowmanCount = compound.m_128451_("snowman_count");
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

