/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import gigaherz.packingtape.PackingTapeMod;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigValues {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int tapeRollUses;
    public static boolean consumesPaper;
    public static TagKey<BlockEntityType<?>> TE_WHITELIST;
    public static TagKey<BlockEntityType<?>> TE_BLACKLIST;
    public static TagKey<Block> BLOCK_WHITELIST;
    public static TagKey<Block> BLOCK_BLACKLIST;

    public static void bake() {
        tapeRollUses = (Integer)ConfigValues.SERVER.tapeRollUses.get();
        consumesPaper = (Boolean)ConfigValues.SERVER.consumesPaper.get();
    }

    public static boolean isBlockEntityWhitelisted(BlockEntity be) {
        Block block = be.m_58900_().m_60734_();
        ResourceKey rk0 = (ResourceKey)ForgeRegistries.BLOCKS.getResourceKey((Object)block).orElseThrow();
        Holder holder0 = (Holder)ForgeRegistries.BLOCKS.getHolder(rk0).orElseThrow();
        if (holder0.m_203656_(BLOCK_WHITELIST)) {
            return true;
        }
        BlockEntityType type = be.m_58903_();
        ResourceKey rk1 = (ResourceKey)ForgeRegistries.BLOCK_ENTITY_TYPES.getResourceKey((Object)type).orElseThrow();
        Holder holder1 = (Holder)ForgeRegistries.BLOCK_ENTITY_TYPES.getHolder(rk1).orElseThrow();
        return holder1.m_203656_(TE_WHITELIST);
    }

    public static boolean isBlockEntityBlocked(BlockEntity be) {
        Block block = be.m_58900_().m_60734_();
        ResourceKey rk0 = (ResourceKey)ForgeRegistries.BLOCKS.getResourceKey((Object)block).orElseThrow();
        Holder holder0 = (Holder)ForgeRegistries.BLOCKS.getHolder(rk0).orElseThrow();
        if (holder0.m_203656_(BLOCK_WHITELIST)) {
            return false;
        }
        if (holder0.m_203656_(BLOCK_BLACKLIST)) {
            return true;
        }
        BlockEntityType type = be.m_58903_();
        ResourceKey rk1 = (ResourceKey)ForgeRegistries.BLOCK_ENTITY_TYPES.getResourceKey((Object)type).orElseThrow();
        Holder holder1 = (Holder)ForgeRegistries.BLOCK_ENTITY_TYPES.getHolder(rk1).orElseThrow();
        if (holder1.m_203656_(TE_WHITELIST)) {
            return false;
        }
        if (be.m_6326_()) {
            return true;
        }
        return holder1.m_203656_(TE_BLACKLIST);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        tapeRollUses = 8;
        consumesPaper = true;
        TE_WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256922_, (ResourceLocation)PackingTapeMod.location("te_whitelist"));
        TE_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256922_, (ResourceLocation)PackingTapeMod.location("te_blacklist"));
        BLOCK_WHITELIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)PackingTapeMod.location("te_whitelist"));
        BLOCK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)PackingTapeMod.location("te_blacklist"));
    }

    public static class ServerConfig {
        public ForgeConfigSpec.IntValue tapeRollUses;
        public ForgeConfigSpec.BooleanValue consumesPaper;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.tapeRollUses = builder.comment("How many times the tape roll can be used before it breaks").translation("text.packingtape.config.tape_roll_uses").defineInRange("tape_roll_uses", 8, 0, 0x7FFFFFFE);
            this.consumesPaper = builder.comment("Whether the tape roll consumes paper when used").translation("text.packingtape.config.consume_paper").define("consume_paper", true);
            builder.pop();
        }
    }
}

