/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.client.render.StaminaWheelConstants;
import tictim.paraglider.client.render.StaminaWheelRenderer;

public class InGameStaminaWheelRenderer
extends StaminaWheelRenderer {
    private boolean full;
    private long fullTime;

    @Override
    protected void makeWheel(@NotNull Player player, @NotNull StaminaWheelRenderer.Wheel wheel) {
        Stamina s = Stamina.get(player);
        int maxStamina = s.maxStamina();
        int stamina = Math.min(maxStamina, s.stamina());
        if (stamina >= maxStamina) {
            long timeDiff;
            long time = ParagliderUtils.ms();
            if (!this.full) {
                this.full = true;
                this.fullTime = time;
                timeDiff = 0L;
            } else {
                timeDiff = time - this.fullTime;
            }
            int color = StaminaWheelConstants.getGlowAndFadeColor(timeDiff);
            if (FastColor.ARGB32.m_13655_((int)color) <= 0) {
                return;
            }
            wheel.fill(0, stamina, color);
        } else {
            this.full = false;
            boolean depleted = s.isDepleted();
            int color = FastColor.ARGB32.m_269105_((float)StaminaWheelConstants.cycle(ParagliderUtils.ms(), depleted ? 600L : 300L), (int)StaminaWheelConstants.DEPLETED_1, (int)StaminaWheelConstants.DEPLETED_2);
            Movement movement = Movement.get(player);
            PlayerState state = movement.state();
            wheel.fill(0, maxStamina, StaminaWheelConstants.EMPTY);
            if (depleted) {
                wheel.fill(0, stamina, color);
            } else {
                wheel.fill(0, stamina, StaminaWheelConstants.IDLE);
                if (state.staminaDelta() < 0) {
                    wheel.fill(stamina + state.staminaDelta() * 10, stamina, color);
                }
            }
        }
    }
}

