/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.client.screen.ParagliderSettingScreen;
import tictim.paraglider.config.DebugCfg;

@Mod.EventBusSubscriber(modid="paraglider", value={Dist.CLIENT})
public final class ParagliderClientEventHandler {
    private ParagliderClientEventHandler() {
    }

    @SubscribeEvent
    public static void onOffHandRender(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Movement m = Movement.get((Player)player);
        if (m.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void customizeDebugText(CustomizeGuiOverlayEvent.DebugText event) {
        if (!DebugCfg.get().debugPlayerMovement()) {
            return;
        }
        LocalPlayer p = Minecraft.m_91087_().f_91074_;
        if (p == null) {
            return;
        }
        ParagliderUtils.addDebugText((Player)p, event.getRight());
    }

    @SubscribeEvent
    public static void beforeCrosshairRender(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.CROSSHAIR.id()) && Minecraft.m_91087_().f_91080_ instanceof BargainScreen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.m_91087_().f_91080_ == null && ParagliderMod.instance().getParagliderSettingsKey().m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ParagliderSettingScreen());
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isPickBlock()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Movement movement = Movement.get((Player)player);
        if (movement.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            event.setSwingHand(false);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockSelection(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Movement movement = Movement.get((Player)player);
        if (movement.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            event.setCanceled(true);
        }
    }
}

