/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import mod.motivationaldragon.potionblender.Constants;
import mod.motivationaldragon.potionblender.config.ItemSerializer;
import mod.motivationaldragon.potionblender.config.PotionBlenderConfig;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class ConfigController {
    private static final String CONFIG_FILE_NAME = "potion_blender_config.json";
    public static final int CONFIG_VERSION = 1;
    private static final Path CONFIG_DIR_PATH = Path.of("config", "potionblender");
    private static final Path CONFIG_FILE_PATH = Path.of("config", "potionblender", "potion_blender_config.json");
    private static final Gson JSON_PARSER = new GsonBuilder().setPrettyPrinting().registerTypeHierarchyAdapter(Item.class, (Object)new ItemSerializer()).create();
    private static PotionBlenderConfig config;
    private static boolean isInitialized;

    private ConfigController() {
    }

    public static PotionBlenderConfig getConfig() {
        if (config == null || !isInitialized) {
            ConfigController.readConfig();
        }
        return config;
    }

    private static void readConfig() {
        if (!isInitialized) {
            ConfigController.init();
        }
        try {
            String jsonString = Files.readString(CONFIG_FILE_PATH);
            config = ConfigController.deserializeConfig(jsonString);
            Constants.LOG.info("Loaded config");
            if (config.getConfigVersion() < 1) {
                Constants.LOG.warn("Old or missing config detected. Default value for missing entries will be generated");
                config.setConfigVersion(1);
                ConfigController.saveConfig(config);
            }
            return;
        }
        catch (IOException e) {
            Constants.LOG.error("Could not read config file");
            e.printStackTrace();
            Constants.LOG.warn("Unable to read config, using default values as fallback");
            config = new PotionBlenderConfig();
            return;
        }
    }

    public static void init() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            Files.createDirectories(CONFIG_DIR_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to create config directory! Check log for error");
            e.printStackTrace();
        }
        if (Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
            return;
        }
        Constants.LOG.info("No config file found, creating a new one at: %s".formatted(CONFIG_FILE_PATH.toAbsolutePath()));
        ConfigController.saveConfig(new PotionBlenderConfig());
    }

    private static void saveConfig(PotionBlenderConfig config) {
        try {
            Path dirPath = Path.of("potionblender", new String[0]);
            Files.createDirectories(dirPath, new FileAttribute[0]);
            try (FileWriter fileWriter = new FileWriter(CONFIG_FILE_PATH.toFile(), false);){
                String jsonString = ConfigController.serializeConfig(config);
                fileWriter.write(jsonString);
                Constants.LOG.info("Successfully wrote config to disk");
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Could not access config file");
            e.printStackTrace();
        }
    }

    public static PotionBlenderConfig deserializeConfig(String configAsJson) {
        try {
            PotionBlenderConfig potionBlenderConfig = (PotionBlenderConfig)JSON_PARSER.fromJson(configAsJson, PotionBlenderConfig.class);
            return Objects.requireNonNullElseGet(potionBlenderConfig, ConfigController::getFallback);
        }
        catch (JsonSyntaxException e) {
            Constants.LOG.error("Could not parse config JSON. Make sure syntax is correct");
            e.printStackTrace();
            return ConfigController.getFallback();
        }
    }

    @NotNull
    private static PotionBlenderConfig getFallback() {
        Constants.LOG.warn("Unable to deserialize config, using a default one as fallback");
        return new PotionBlenderConfig();
    }

    public static String serializeConfig(PotionBlenderConfig config) {
        return JSON_PARSER.toJson((Object)config);
    }

    static {
        isInitialized = false;
    }
}

