/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.violetmoon.quark.api.ICrawlSpaceBlock;
import org.violetmoon.quark.content.building.block.HollowLogBlock;
import org.violetmoon.zeta.advancement.ManualTrigger;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.VanillaWoods;

@ZetaLoadModule(category="building")
public class HollowLogsModule
extends ZetaModule {
    private static final String TAG_TRYING_TO_CRAWL = "quark:trying_crawl";
    public static ManualTrigger crawlTrigger;
    @Config(flag="hollow_log_auto_crawl")
    public static boolean enableAutoCrawl;
    @Hint(key="hollow_logs", value="hollow_log_auto_crawl")
    public static TagKey<Block> hollowLogsTag;

    @LoadEvent
    public final void register(ZRegister event) {
        for (VanillaWoods.Wood wood : VanillaWoods.ALL_WITH_LOGS) {
            new HollowLogBlock(wood.log(), (ZetaModule)this, !wood.nether());
        }
        crawlTrigger = event.getAdvancementModifierRegistry().registerManualTrigger("hollow_log_crawl");
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        hollowLogsTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "hollow_logs"));
    }

    @PlayEvent
    public void playerTick(ZPlayerTick.Start event) {
        if (enableAutoCrawl) {
            Player player = event.getPlayer();
            BlockPos playerPos = player.m_20183_();
            boolean isTrying = player.m_20143_() || player.m_6047_() && !player.m_20039_(playerPos, player.m_9236_().m_8055_(playerPos));
            boolean wasTrying = player.getPersistentData().m_128471_(TAG_TRYING_TO_CRAWL);
            if (!player.m_20143_() && isTrying && !wasTrying) {
                Direction dir = player.m_6350_();
                Direction opp = dir.m_122424_();
                if (dir.m_122434_() != Direction.Axis.Y) {
                    BlockPos pos = playerPos.m_121945_(dir);
                    if (!(this.tryClimb(player, opp, playerPos) || this.tryClimb(player, opp, playerPos.m_7494_()) || this.tryClimb(player, dir, pos))) {
                        this.tryClimb(player, dir, pos.m_7494_());
                    }
                }
            }
            if (isTrying != wasTrying) {
                player.getPersistentData().m_128379_(TAG_TRYING_TO_CRAWL, isTrying);
            }
        }
    }

    private boolean tryClimb(Player player, Direction dir, BlockPos pos) {
        ICrawlSpaceBlock crawlSpace;
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ICrawlSpaceBlock && (crawlSpace = (ICrawlSpaceBlock)block).canCrawl(player.m_9236_(), state, pos, dir)) {
            ServerPlayer sp;
            player.m_20124_(Pose.SWIMMING);
            player.m_20282_(true);
            double x = (double)pos.m_123341_() + 0.5 - (double)dir.m_122429_() * 0.3;
            double y = (double)pos.m_123342_() + crawlSpace.crawlHeight(player.m_9236_(), state, pos, dir);
            double z = (double)pos.m_123343_() + 0.5 - (double)dir.m_122431_() * 0.3;
            player.m_6034_(x, y, z);
            if (player instanceof ServerPlayer && crawlSpace.isLog(sp = (ServerPlayer)player, state, pos, dir)) {
                crawlTrigger.trigger(sp);
            }
            return true;
        }
        return false;
    }

    static {
        enableAutoCrawl = true;
    }
}

