/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.quark.content.tools.client.tooltip.SeedPouchClientTooltipComponent;
import org.violetmoon.quark.content.tools.item.SeedPouchItem;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.load.ZTooltipComponents;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityItemPickup;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class SeedPouchModule
extends ZetaModule {
    @Hint
    public static Item seed_pouch;
    public static TagKey<Item> seedPouchHoldableTag;
    @Config
    public static int maxItems;
    @Config
    public static boolean showAllVariantsInCreative;
    @Config
    public static int shiftRange;

    @LoadEvent
    public final void register(ZRegister event) {
        seed_pouch = new SeedPouchItem(this);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        seedPouchHoldableTag = ItemTags.create((ResourceLocation)new ResourceLocation("quark", "seed_pouch_holdable"));
    }

    @PlayEvent
    public void onItemPickup(ZEntityItemPickup event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getItem().m_32055_();
        ItemStack main = player.m_21205_();
        ItemStack off = player.m_21206_();
        ImmutableSet stacks = ImmutableSet.of((Object)main, (Object)off);
        for (ItemStack heldStack : stacks) {
            ItemStack pouchStack;
            Pair<ItemStack, Integer> contents;
            if (heldStack.m_41720_() != seed_pouch || heldStack.m_41613_() != 1 || (contents = SeedPouchItem.getContents(heldStack)) == null || !ItemStack.m_41656_((ItemStack)(pouchStack = (ItemStack)contents.getLeft()), (ItemStack)stack)) continue;
            int curr = (Integer)contents.getRight();
            int missing = maxItems - curr;
            int count = stack.m_41613_();
            int toAdd = Math.min(missing, count);
            stack.m_41764_(count - toAdd);
            SeedPouchItem.setCount(heldStack, curr + toAdd);
            if (player.m_9236_() instanceof ServerLevel) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.2f, (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 1.4f + 2.0f);
            }
            if (stack.m_41613_() != 0) continue;
            break;
        }
    }

    static {
        maxItems = 640;
        showAllVariantsInCreative = true;
        shiftRange = 3;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends SeedPouchModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> ItemProperties.register((Item)seed_pouch, (ResourceLocation)new ResourceLocation("pouch_items"), SeedPouchItem::itemFraction));
        }

        @LoadEvent
        public void registerClientTooltipComponentFactories(ZTooltipComponents event) {
            event.register(SeedPouchItem.Tooltip.class, t -> new SeedPouchClientTooltipComponent(t.stack()));
        }
    }
}

