/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.quark.content.client.tooltip.EnchantedBookTooltips;
import org.violetmoon.quark.content.tools.base.RuneColor;
import org.violetmoon.quark.content.tools.module.ColorRunesModule;
import org.violetmoon.quark.content.tools.module.PickarangModule;
import org.violetmoon.zeta.module.IDisableable;

public final class SmithingRuneRecipe
extends SmithingTrimRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation id;
    private final Ingredient template;
    private final Ingredient addition;
    private final RuneColor runeColor;
    private static Ingredient used;
    private static final RandomSource BASE_INGREDIENT_RANDOM;

    private static ItemStack makeEnchantedDisplayItem(ItemStack input) {
        ItemStack stack = input.m_41777_();
        stack.m_41654_(ItemStack.TooltipPart.ENCHANTMENTS);
        stack.m_41654_(ItemStack.TooltipPart.MODIFIERS);
        stack.m_41714_((Component)Component.m_237115_((String)"quark.jei.any_enchanted"));
        if (Quark.ZETA.itemExtensions.get(stack).getEnchantmentValueZeta(stack) <= 0) {
            stack.m_41663_(Enchantments.f_44986_, 3);
            return stack;
        }
        return EnchantmentHelper.m_220292_((RandomSource)BASE_INGREDIENT_RANDOM, (ItemStack)stack, (int)25, (boolean)false);
    }

    private static Ingredient createBaseIngredient() {
        if (used == null) {
            Stream<Object> displayItems = Quark.ZETA.modules.isEnabled(ImprovedTooltipsModule.class) && ImprovedTooltipsModule.enchantingTooltips ? EnchantedBookTooltips.getTestItems().stream() : Stream.of(Items.f_42388_, Items.f_42390_, Items.f_42391_, Items.f_42389_, Items.f_42392_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42741_, Items.f_42740_, Items.f_42411_, Items.f_42717_, Items.f_42713_, Items.f_42523_, Items.f_42574_, PickarangModule.pickarang).map(ItemStack::new);
            used = Ingredient.m_43921_(displayItems.filter(it -> {
                IDisableable dis;
                Item patt3269$temp = it.m_41720_();
                return !(patt3269$temp instanceof IDisableable) || (dis = (IDisableable)patt3269$temp).isEnabled();
            }).map(SmithingRuneRecipe::makeEnchantedDisplayItem));
        }
        return used;
    }

    private SmithingRuneRecipe(ResourceLocation id, Ingredient template, Ingredient addition, RuneColor runeColor) {
        super(id, template, SmithingRuneRecipe.createBaseIngredient(), addition);
        this.id = id;
        this.template = template;
        this.addition = addition;
        this.runeColor = runeColor;
    }

    public boolean m_5818_(Container container, @Nonnull Level level) {
        return this.m_266166_(container.m_8020_(0)) && this.m_266343_(container.m_8020_(1)) && this.m_266253_(container.m_8020_(2));
    }

    @Nonnull
    public ItemStack m_5874_(Container container, @Nonnull RegistryAccess registry) {
        ItemStack baseItem = container.m_8020_(1);
        if (this.m_266343_(baseItem)) {
            if (ColorRunesModule.getStackColor(baseItem) == this.runeColor) {
                return ItemStack.f_41583_;
            }
            ItemStack newStack = baseItem.m_41777_();
            newStack.m_41764_(1);
            return ColorRunesModule.withRune(newStack, this.runeColor);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registry) {
        ItemStack displayStack = SmithingRuneRecipe.makeEnchantedDisplayItem(new ItemStack((ItemLike)Items.f_42469_));
        ColorRunesModule.withRune(displayStack, this.runeColor);
        return displayStack;
    }

    public boolean m_266166_(@Nonnull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(@Nonnull ItemStack stack) {
        return ColorRunesModule.canHaveRune(stack);
    }

    public boolean m_266253_(@Nonnull ItemStack stack) {
        if (this.addition.m_43947_()) {
            return stack.m_41619_();
        }
        return this.addition.test(stack);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    static {
        BASE_INGREDIENT_RANDOM = RandomSource.m_216337_();
    }

    public static class Serializer
    implements RecipeSerializer<SmithingRuneRecipe> {
        @Nonnull
        public SmithingRuneRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject serialized) {
            Ingredient template = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)serialized, (String)"template"));
            JsonElement additionElement = serialized.get("addition");
            Ingredient addition = additionElement != null && !additionElement.isJsonNull() ? Ingredient.m_43917_((JsonElement)additionElement) : Ingredient.f_43901_;
            RuneColor runeColor = RuneColor.byName(GsonHelper.m_13906_((JsonObject)serialized, (String)"color"));
            if (runeColor == null) {
                throw new JsonSyntaxException("Rune color must be a valid dye color, rainbow, or blank");
            }
            return new SmithingRuneRecipe(id, template, addition, runeColor);
        }

        public SmithingRuneRecipe fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buf) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient addition = buf.readBoolean() ? Ingredient.f_43901_ : Ingredient.m_43940_((FriendlyByteBuf)buf);
            RuneColor runeColor = (RuneColor)buf.m_130066_(RuneColor.class);
            return new SmithingRuneRecipe(id, template, addition, runeColor);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, SmithingRuneRecipe recipe) {
            recipe.template.m_43923_(buf);
            boolean additionIsEmpty = recipe.addition.m_43947_();
            buf.writeBoolean(additionIsEmpty);
            if (!additionIsEmpty) {
                recipe.addition.m_43923_(buf);
            }
            buf.m_130068_((Enum)recipe.runeColor);
        }
    }
}

