/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.povstalec.sgjourney.client.Layers;
import net.povstalec.sgjourney.client.render.block_entity.CartoucheRenderer;
import net.povstalec.sgjourney.client.render.block_entity.ClassicStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.MilkyWayStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.PegasusStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.SymbolBlockRenderer;
import net.povstalec.sgjourney.client.render.block_entity.TollanStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.TransportRingsRenderer;
import net.povstalec.sgjourney.client.render.block_entity.UniverseStargateRenderer;
import net.povstalec.sgjourney.client.render.entity.PlasmaProjectileRenderer;
import net.povstalec.sgjourney.client.render.level.SGJourneyDimensionSpecialEffects;
import net.povstalec.sgjourney.client.render.level.StellarViewRendering;
import net.povstalec.sgjourney.client.screens.ClassicDHDScreen;
import net.povstalec.sgjourney.client.screens.CrystallizerScreen;
import net.povstalec.sgjourney.client.screens.DHDCrystalScreen;
import net.povstalec.sgjourney.client.screens.InterfaceScreen;
import net.povstalec.sgjourney.client.screens.MilkyWayDHDScreen;
import net.povstalec.sgjourney.client.screens.NaquadahGeneratorScreen;
import net.povstalec.sgjourney.client.screens.NaquadahLiquidizerScreen;
import net.povstalec.sgjourney.client.screens.PegasusDHDScreen;
import net.povstalec.sgjourney.client.screens.RingPanelScreen;
import net.povstalec.sgjourney.client.screens.ZPMHubScreen;
import net.povstalec.sgjourney.client.screens.config.ConfigScreen;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.FeatureInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.FluidTypeInit;
import net.povstalec.sgjourney.common.init.GalaxyInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.init.MiscInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.RecipeTypeInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.StructureInit;
import net.povstalec.sgjourney.common.init.TabInit;
import net.povstalec.sgjourney.common.init.VillagerInit;
import net.povstalec.sgjourney.common.items.properties.LiquidNaquadahPropertyFunction;
import net.povstalec.sgjourney.common.items.properties.WeaponStatePropertyFunction;
import net.povstalec.sgjourney.common.stargate.AddressTable;
import net.povstalec.sgjourney.common.stargate.Galaxy;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.SolarSystem;
import net.povstalec.sgjourney.common.stargate.StargateVariant;
import net.povstalec.sgjourney.common.stargate.SymbolSet;
import net.povstalec.sgjourney.common.stargate.Symbols;
import net.povstalec.sgjourney.common.world.biomemod.BiomeModifiers;
import org.slf4j.Logger;

@Mod(value="sgjourney")
public class StargateJourney {
    public static final String MODID = "sgjourney";
    public static final String EMPTY = "sgjourney:empty";
    public static final String STELLAR_VIEW_MODID = "stellarview";
    public static final String OCULUS_MODID = "oculus";
    private static Optional<Boolean> isOculusLoaded = Optional.empty();
    public static final Logger LOGGER = LogUtils.getLogger();

    public StargateJourney() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemInit.register(eventBus);
        BlockInit.register(eventBus);
        FluidInit.register(eventBus);
        FluidTypeInit.register(eventBus);
        BlockEntityInit.register(eventBus);
        MenuInit.register(eventBus);
        VillagerInit.register(eventBus);
        FeatureInit.register(eventBus);
        StructureInit.register(eventBus);
        BiomeModifiers.register(eventBus);
        EntityInit.register(eventBus);
        SoundInit.register(eventBus);
        TabInit.register(eventBus);
        RecipeTypeInit.register(eventBus);
        GalaxyInit.register(eventBus);
        eventBus.addListener(event -> {
            event.dataPackRegistry(SymbolSet.REGISTRY_KEY, SymbolSet.CODEC, SymbolSet.CODEC);
            event.dataPackRegistry(Symbols.REGISTRY_KEY, Symbols.CODEC, Symbols.CODEC);
            event.dataPackRegistry(PointOfOrigin.REGISTRY_KEY, PointOfOrigin.CODEC, PointOfOrigin.CODEC);
            event.dataPackRegistry(SolarSystem.REGISTRY_KEY, SolarSystem.CODEC, SolarSystem.CODEC);
            event.dataPackRegistry(Galaxy.REGISTRY_KEY, Galaxy.CODEC, Galaxy.CODEC);
            event.dataPackRegistry(AddressTable.REGISTRY_KEY, AddressTable.CODEC, AddressTable.CODEC);
            event.dataPackRegistry(StargateVariant.REGISTRY_KEY, StargateVariant.CODEC, StargateVariant.CODEC);
        });
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(Layers::registerLayers);
        eventBus.addListener(TabInit::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)StargateJourneyConfig.CLIENT_CONFIG, "sgjourney-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StargateJourneyConfig.COMMON_CONFIG, "sgjourney-common.toml");
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((BiFunction)new BiFunction<Minecraft, Screen, Screen>(){

            @Override
            public Screen apply(Minecraft mc, Screen screen) {
                return new ConfigScreen(screen);
            }
        }));
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(MiscInit::registerCommands);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> PacketHandlerInit.register());
    }

    public static boolean isOculusLoaded() {
        if (isOculusLoaded.isEmpty()) {
            isOculusLoaded = Optional.of(ModList.get().isLoaded(OCULUS_MODID));
        }
        return isOculusLoaded.get();
    }

    @Mod.EventBusSubscriber(modid="sgjourney", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemProperties.register((Item)((Item)ItemInit.VIAL.get()), (ResourceLocation)new ResourceLocation(StargateJourney.MODID, "liquid_naquadah"), (ItemPropertyFunction)new LiquidNaquadahPropertyFunction());
            ItemProperties.register((Item)((Item)ItemInit.MATOK.get()), (ResourceLocation)new ResourceLocation(StargateJourney.MODID, "open"), (ItemPropertyFunction)new WeaponStatePropertyFunction());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.LIQUID_NAQUADAH_FLOWING.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_FLOWING.get()), (RenderType)RenderType.m_110466_());
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.INTERFACE.get()), InterfaceScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.RING_PANEL.get()), RingPanelScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.DHD_CRYSTAL.get()), DHDCrystalScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.MILKY_WAY_DHD.get()), MilkyWayDHDScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.PEGASUS_DHD.get()), PegasusDHDScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.CLASSIC_DHD.get()), ClassicDHDScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.NAQUADAH_GENERATOR.get()), NaquadahGeneratorScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.ZPM_HUB.get()), ZPMHubScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.NAQUADAH_LIQUIDIZER.get()), NaquadahLiquidizerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuInit.CRYSTALLIZER.get()), CrystallizerScreen::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityInit.JAFFA_PLASMA.get()), PlasmaProjectileRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get()), CartoucheRenderer.Sandstone::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get()), CartoucheRenderer.Stone::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.SANDSTONE_SYMBOL.get()), SymbolBlockRenderer.Sandstone::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.STONE_SYMBOL.get()), SymbolBlockRenderer.Stone::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get()), TransportRingsRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get()), UniverseStargateRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get()), MilkyWayStargateRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get()), PegasusStargateRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get()), ClassicStargateRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)BlockEntityInit.TOLLAN_STARGATE.get()), TollanStargateRenderer::new);
        }

        @SubscribeEvent
        public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
            if (ModList.get().isLoaded(StargateJourney.STELLAR_VIEW_MODID)) {
                StellarViewRendering.registerStellarViewEffects(event);
            } else {
                SGJourneyDimensionSpecialEffects.registerStargateJourneyEffects(event);
            }
        }
    }
}

