/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.GenericStargateModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.Address;
import net.povstalec.sgjourney.common.stargate.Stargate;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class MilkyWayStargateModel
extends GenericStargateModel<MilkyWayStargateEntity> {
    protected final ResourceLocation alternateStargateTexture;
    protected final ResourceLocation alternateEngagedTexture;

    public MilkyWayStargateModel() {
        super(new ResourceLocation("sgjourney", "milky_way"), (short)39, new Stargate.RGBA(48, 49, 63, 255));
        this.alternateStargateTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate_alternate.png");
        this.alternateEngagedTexture = new ResourceLocation(this.namespace, "textures/entity/stargate/" + this.name + "/" + this.name + "_stargate_alternate_engaged.png");
    }

    @Override
    public void renderStargate(MilkyWayStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        Optional<StargateVariant> stargateVariant = this.getStargateVariant(stargate);
        VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.stargate(this.getStargateTexture(stargate, stargateVariant)));
        this.renderOuterRing(stack, consumer, source, combinedLight);
        this.renderSymbolRing(stargate, stargateVariant, stack, consumer, source, combinedLight, this.rotation);
        this.renderChevrons(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
    }

    @Override
    protected ResourceLocation getStargateTexture(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getTexture();
        }
        return ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? this.alternateStargateTexture : this.stargateTexture;
    }

    @Override
    protected ResourceLocation getEngagedTexture(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent()) {
            return stargateVariant.get().getEngagedTexture();
        }
        return ClientStargateConfig.milky_way_stargate_back_lights_up.get() ? this.alternateEngagedTexture : this.engagedTexture;
    }

    @Override
    protected boolean useMovieStargateModel(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().useAlternateModel().isPresent()) {
            return stargateVariant.get().useAlternateModel().get();
        }
        return ClientStargateConfig.use_movie_stargate_model.get();
    }

    protected boolean raiseBackChevrons(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (stargateVariant.isPresent() && stargateVariant.get().backChevrons().isPresent()) {
            return stargateVariant.get().backChevrons().get();
        }
        return ClientStargateConfig.milky_way_stargate_back_lights_up.get();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    protected boolean isPrimaryChevronRaised(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (this.useMovieStargateModel(stargate, stargateVariant)) {
            if (ClientStargateConfig.movie_primary_chevron_opens.get()) {
                return stargate.isConnected();
            }
            return false;
        }
        return stargate.isChevronOpen();
    }

    @Override
    protected boolean isPrimaryChevronBackRaised(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (!this.raiseBackChevrons(stargate, stargateVariant)) {
            return false;
        }
        return this.isPrimaryChevronRaised(stargate, stargateVariant);
    }

    @Override
    protected boolean isPrimaryChevronLowered(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        return this.isPrimaryChevronRaised(stargate, stargateVariant);
    }

    @Override
    protected boolean isPrimaryChevronEngaged(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant) {
        if (!this.useMovieStargateModel(stargate, stargateVariant) && stargate.isChevronOpen()) {
            return true;
        }
        if (stargate.isConnected()) {
            return stargate.isDialingOut() || stargate.getKawooshTickCount() > 0;
        }
        return false;
    }

    @Override
    protected boolean isChevronRaised(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        Address address;
        if (!this.useMovieStargateModel(stargate, stargateVariant)) {
            return false;
        }
        int chevronsRendered = stargate.chevronsRendered();
        if (stargate.isConnected() && chevronNumber < chevronsRendered + 1) {
            return true;
        }
        return stargate.isChevronOpen() && (stargate.getCurrentSymbol() == 0 || chevronsRendered >= 8 ? chevronNumber < chevronsRendered + 1 : (stargate.isCurrentSymbol((address = stargate.getAddress()).getSymbol(address.getLength() - 1)) ? AbstractStargateEntity.getChevron(stargate, chevronNumber) == AbstractStargateEntity.getChevron(stargate, chevronsRendered) : AbstractStargateEntity.getChevron(stargate, chevronNumber) == AbstractStargateEntity.getChevron(stargate, chevronsRendered + 1)));
    }

    @Override
    protected boolean isChevronBackRaised(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        if (!this.raiseBackChevrons(stargate, stargateVariant)) {
            return false;
        }
        return this.isChevronRaised(stargate, stargateVariant, chevronNumber);
    }

    @Override
    protected boolean isChevronLowered(MilkyWayStargateEntity stargate, Optional<StargateVariant> stargateVariant, int chevronNumber) {
        Address address;
        if (!this.useMovieStargateModel(stargate, stargateVariant)) {
            return false;
        }
        boolean alternateChevronLocking = ClientStargateConfig.alternate_movie_chevron_locking.get();
        int chevronsRendered = stargate.chevronsRendered();
        if (stargate.isConnected() && chevronNumber < chevronsRendered + 1) {
            return true;
        }
        if (stargate.isChevronOpen() && (stargate.getCurrentSymbol() == 0 || chevronsRendered > 8 ? chevronNumber < chevronsRendered + 1 : (stargate.isCurrentSymbol((address = stargate.getAddress()).getSymbol(address.getLength() - 1)) ? AbstractStargateEntity.getChevron(stargate, chevronNumber) == AbstractStargateEntity.getChevron(stargate, chevronsRendered) : AbstractStargateEntity.getChevron(stargate, chevronNumber) == AbstractStargateEntity.getChevron(stargate, chevronsRendered + 1)))) {
            return true;
        }
        return alternateChevronLocking && AbstractStargateEntity.getChevron(stargate, chevronNumber) < AbstractStargateEntity.getChevron(stargate, chevronsRendered + 1);
    }
}

