/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import net.povstalec.sgjourney.client.models.AbstractStargateModel;
import net.povstalec.sgjourney.client.models.ShieldModel;
import net.povstalec.sgjourney.client.models.WormholeModel;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public abstract class AbstractStargateRenderer {
    protected final WormholeModel wormholeModel;
    protected final ShieldModel shieldModel = new ShieldModel();

    public AbstractStargateRenderer(BlockEntityRendererProvider.Context context, ResourceLocation eventHorizonTexture, ResourceLocation shinyEventHorizonTexture, float maxDefaultDistortion) {
        this.wormholeModel = new WormholeModel(eventHorizonTexture, Optional.of(shinyEventHorizonTexture), maxDefaultDistortion);
    }

    public AbstractStargateRenderer(BlockEntityRendererProvider.Context context, ResourceLocation eventHorizonTexture, float maxDefaultDistortion) {
        this.wormholeModel = new WormholeModel(eventHorizonTexture, Optional.empty(), maxDefaultDistortion);
    }

    protected void renderWormhole(AbstractStargateEntity stargate, PoseStack stack, MultiBufferSource source, @Nullable AbstractStargateModel model, int combinedLight, int combinedOverlay) {
        StargateVariant variant;
        Optional<StargateVariant> variantOptional;
        Optional<ResourceLocation> eventHorizonTexture = Optional.empty();
        if (model != null && (variantOptional = AbstractStargateModel.getVariant(stargate)).isPresent() && model.canUseVariant(variant = variantOptional.get())) {
            eventHorizonTexture = ClientStargateConfig.shiny_event_horizons.get() && variant.getShinyEventHorizonTexture().isPresent() ? variant.getShinyEventHorizonTexture() : Optional.of(variant.getEventHorizonTexture());
        }
        if (stargate.isConnected()) {
            this.wormholeModel.renderEventHorizon(stargate, stack, source, eventHorizonTexture, combinedLight, combinedOverlay);
        }
    }

    protected void renderCover(AbstractStargateEntity stargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft:red_sand"));
        this.renderCoverBlock(stargate, block.m_49966_(), StargatePart.LEFT2, stack, source, combinedOverlay);
        this.renderCoverBlock(stargate, block.m_49966_(), StargatePart.LEFT, stack, source, combinedOverlay);
        this.renderCoverBlock(stargate, block.m_49966_(), StargatePart.BASE, stack, source, combinedOverlay);
        this.renderCoverBlock(stargate, block.m_49966_(), StargatePart.RIGHT, stack, source, combinedOverlay);
        this.renderCoverBlock(stargate, block.m_49966_(), StargatePart.RIGHT2, stack, source, combinedOverlay);
    }

    protected void renderCoverBlock(AbstractStargateEntity stargate, BlockState state, StargatePart part, PoseStack stack, MultiBufferSource source, int combinedOverlay) {
        Level level = stargate.m_58904_();
        Direction direction = stargate.getDirection();
        Orientation orientation = stargate.getOrientation();
        if (direction != null && orientation != null) {
            Vec3 relativeBlockPos = part.getRelativeRingPos(stargate.m_58899_(), direction, orientation);
            BlockPos absolutePos = part.getRingPos(stargate.m_58899_(), stargate.getDirection(), stargate.getOrientation());
            stack.m_85836_();
            stack.m_85837_(relativeBlockPos.m_7096_(), relativeBlockPos.m_7098_(), relativeBlockPos.m_7094_());
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            dispatcher.renderSingleBlock(state, stack, source, LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)absolutePos), combinedOverlay, ModelData.EMPTY, null);
            stack.m_85849_();
        }
    }
}

