/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.models.MilkyWayStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.MilkyWayStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class MilkyWayStargateRenderer
extends AbstractStargateRenderer
implements BlockEntityRenderer<MilkyWayStargateEntity> {
    protected final MilkyWayStargateModel stargateModel = new MilkyWayStargateModel();
    private static final ResourceLocation EVENT_HORIZON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/milky_way/milky_way_event_horizon.png");
    private static final ResourceLocation SHINY_EVENT_HORIZON_TEXTURE = new ResourceLocation("sgjourney", "textures/entity/stargate/milky_way/milky_way_event_horizon_shiny.png");

    public MilkyWayStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, EVENT_HORIZON_TEXTURE, SHINY_EVENT_HORIZON_TEXTURE, 0.25f);
    }

    public void render(MilkyWayStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        BlockState blockstate = stargate.m_58900_();
        float facing = ((Direction)blockstate.m_61143_((Property)MilkyWayStargateBlock.FACING)).m_122435_();
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_((Property)AbstractStargateBaseBlock.ORIENTATION));
        stack.m_85836_();
        stack.m_85837_(center.m_7096_(), center.m_7098_(), center.m_7094_());
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        this.stargateModel.setRotation(stargate.getRotation(partialTick) / 312.0f * 360.0f);
        this.stargateModel.renderStargate(stargate, partialTick, stack, source, combinedLight, combinedOverlay);
        this.renderWormhole(stargate, stack, source, this.stargateModel, combinedLight, combinedOverlay);
        stack.m_85849_();
    }

    public int m_142163_() {
        return 128;
    }
}

