/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.block_entities.SymbolBlockEntity;
import net.povstalec.sgjourney.common.blocks.SymbolBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public abstract class SymbolBlockRenderer {
    private static final ResourceLocation ERROR = new ResourceLocation("sgjourney", "textures/symbols/error.png");
    protected static final float SYMBOL_OFFSET = 0.51f;
    protected static final float SYMBOL_SIZE = 1.0f;
    protected static final float SYMBOL_START = -0.5f;
    protected static final float SYMBOL_END = 0.5f;
    protected int red;
    protected int green;
    protected int blue;

    public SymbolBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected PointOfOrigin getPointOfOrigin(SymbolBlockEntity symbolBlock) {
        String pointOfOrigin = symbolBlock.symbol;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry registry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        return (PointOfOrigin)registry.m_7745_(new ResourceLocation(pointOfOrigin));
    }

    protected void renderSymbol(VertexConsumer consumer, Matrix4f matrix4, Matrix3f matrix3, int light) {
        consumer.m_252986_(matrix4, -0.5f, 0.5f, 0.51f).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, -0.5f, -0.5f, 0.51f).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, 0.5f, -0.5f, 0.51f).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
        consumer.m_252986_(matrix4, 0.5f, 0.5f, 0.51f).m_85950_((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(matrix3, 0.0f, 0.0f, 1.0f).m_5752_();
    }

    protected void renderSymbolBlock(SymbolBlockEntity symbol, PoseStack stack, MultiBufferSource source, int light) {
        BlockState blockstate = symbol.m_58900_();
        float facing = ((Direction)blockstate.m_61143_((Property)SymbolBlock.f_52588_)).m_122435_();
        Direction direction = (Direction)blockstate.m_61143_((Property)SymbolBlock.f_52588_);
        Orientation orientation = (Orientation)((Object)blockstate.m_61143_(SymbolBlock.ORIENTATION));
        BlockPos pos = symbol.m_58899_().m_121945_(Orientation.getEffectiveDirection(direction, orientation));
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(Axis.f_252436_.m_252977_(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        }
        if (symbol != null) {
            Matrix4f matrix4 = stack.m_85850_().m_252922_();
            Matrix3f matrix3 = stack.m_85850_().m_252943_();
            PointOfOrigin pointOfOrigin = this.getPointOfOrigin(symbol);
            ResourceLocation texture = pointOfOrigin != null ? pointOfOrigin.texture() : ERROR;
            light = LevelRenderer.m_109541_((BlockAndTintGetter)symbol.m_58904_(), (BlockPos)pos);
            VertexConsumer consumer = source.m_6299_(SGJourneyRenderTypes.symbol(texture));
            this.renderSymbol(consumer, matrix4, matrix3, light);
        }
        stack.m_85849_();
    }

    public static class Sandstone
    extends SymbolBlockRenderer
    implements BlockEntityRenderer<SymbolBlockEntity.Sandstone> {
        public Sandstone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 198;
            this.green = 174;
            this.blue = 113;
        }

        public void render(SymbolBlockEntity.Sandstone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderSymbolBlock(symbol, stack, source, combinedLight);
        }
    }

    public static class Stone
    extends SymbolBlockRenderer
    implements BlockEntityRenderer<SymbolBlockEntity.Stone> {
        public Stone(BlockEntityRendererProvider.Context context) {
            super(context);
            this.red = 90;
            this.green = 89;
            this.blue = 90;
        }

        public void render(SymbolBlockEntity.Stone symbol, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
            this.renderSymbolBlock(symbol, stack, source, combinedLight);
        }
    }
}

