/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.povstalec.sgjourney.client.render.level.SGJourneyDimensionSpecialEffects;
import net.povstalec.sgjourney.common.config.ClientSkyConfig;
import net.povstalec.stellarview.api.StellarViewSpecialEffects;
import net.povstalec.stellarview.api.celestials.Galaxy;
import net.povstalec.stellarview.api.celestials.StellarObject;
import net.povstalec.stellarview.api.celestials.Supernova;
import net.povstalec.stellarview.api.celestials.orbiting.BlackHole;
import net.povstalec.stellarview.api.celestials.orbiting.Moon;
import net.povstalec.stellarview.api.celestials.orbiting.OrbitingCelestialObject;
import net.povstalec.stellarview.api.celestials.orbiting.Planet;
import net.povstalec.stellarview.api.celestials.orbiting.Sun;
import net.povstalec.stellarview.api.sky_effects.MeteorShower;
import net.povstalec.stellarview.api.sky_effects.ShootingStar;
import net.povstalec.stellarview.client.render.level.StellarViewSky;
import org.joml.Matrix4f;

public class StellarViewRendering {
    public static void registerStellarViewEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(SGJourneyDimensionSpecialEffects.ABYDOS_EFFECTS, (DimensionSpecialEffects)new StellarViewAbydosEffects());
        event.register(SGJourneyDimensionSpecialEffects.CHULAK_EFFECTS, (DimensionSpecialEffects)new StellarViewChulakEffects());
        event.register(SGJourneyDimensionSpecialEffects.CAVUM_TENEBRAE_EFFECTS, (DimensionSpecialEffects)new StellarViewCavumTenebraeEffects());
        event.register(SGJourneyDimensionSpecialEffects.LANTEA_EFFECTS, (DimensionSpecialEffects)new StellarViewLanteaEffects());
        event.register(SGJourneyDimensionSpecialEffects.ATHOS_EFFECTS, (DimensionSpecialEffects)new StellarViewAthosEffects());
    }

    public static class StellarViewAbydosEffects
    extends StellarViewSpecialEffects {
        private static final Moon EDFU = new Moon.DefaultMoon(15.0f);
        private static final Moon DJA_NET = new Moon.DefaultMoon(20.0f);
        private static final Moon NUTURO = new Moon.DefaultMoon(30.0f);
        private static final Planet ABYDOS = (Planet)new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000).addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setDefaultRarity(10), (MeteorShower)new MeteorShower().setDefaultRarity(10))).addOrbitingObject((OrbitingCelestialObject)EDFU, 384400.0f, 45.0f, (float)Math.toRadians(45.0), 0.0f, 0.0f).addOrbitingObject((OrbitingCelestialObject)DJA_NET, 384400.0f, 45.0f, (float)Math.toRadians(35.0), (float)Math.toRadians(75.0), 0.0f).addOrbitingObject((OrbitingCelestialObject)NUTURO, 384400.0f, 45.0f, (float)Math.toRadians(40.0), (float)Math.toRadians(-55.0), 0.0f);
        private static final Sun ABYDOS_SUN = (Sun)new Sun.DefaultSun(50.0f).addOrbitingObject((OrbitingCelestialObject)ABYDOS, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
        private static final Galaxy.SpiralGalaxy MILKY_WAY = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(100.0f, 10842L, 4, 1500).addGalacticObject((StellarObject)new Supernova(10.0f, 378000L, 120000L), 10.0f, -3.0f, 2.0f).addGalacticObject((StellarObject)ABYDOS_SUN, 1.0f, 8.0f, 17.0f, 0.0f, 0.0f, 0.0f);

        public StellarViewAbydosEffects() {
            super(new StellarViewSky((OrbitingCelestialObject)ABYDOS), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            MILKY_WAY.setStarBuffer(1.0f, 8.0f, 17.0f, 0.0f, 0.0f, 0.0f);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (ClientSkyConfig.custom_abydos_sky.get()) {
                super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
            }
            return ClientSkyConfig.custom_abydos_sky.get();
        }
    }

    public static class StellarViewChulakEffects
    extends StellarViewSpecialEffects {
        private static final Moon JERBAAS = new Moon.DefaultMoon(25.0f);
        private static final Planet CHULAK = (Planet)new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000).addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setDefaultRarity(10), (MeteorShower)new MeteorShower().setDefaultRarity(10))).addOrbitingObject((OrbitingCelestialObject)JERBAAS, 384400.0f, 45.0f, (float)Math.toRadians(45.0), (float)Math.toRadians(63.0), 0.0f);
        private static final Sun CHULAK_SUN = (Sun)new Sun.VanillaSun().addOrbitingObject((OrbitingCelestialObject)CHULAK, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
        private static final Galaxy.SpiralGalaxy MILKY_WAY = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(100.0f, 10842L, 4, 1500).addGalacticObject((StellarObject)new Supernova(10.0f, 378000L, 120000L), 10.0f, -3.0f, 2.0f).addGalacticObject((StellarObject)CHULAK_SUN, 6.0f, -2.0f, 8.0f, 0.0f, 0.62831855f, 1.8849556f);

        public StellarViewChulakEffects() {
            super(new StellarViewSky((OrbitingCelestialObject)CHULAK), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            MILKY_WAY.setStarBuffer(6.0f, -2.0f, 8.0f, 0.0f, 0.62831855f, 1.8849556f);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (ClientSkyConfig.custom_chulak_sky.get()) {
                super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
            }
            return ClientSkyConfig.custom_chulak_sky.get();
        }
    }

    public static class StellarViewCavumTenebraeEffects
    extends StellarViewSpecialEffects {
        private static final Planet CAVUM_TENBRAE = new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000);
        private static final BlackHole P3W_451_BLACK_HOLE = (BlackHole)new BlackHole.DefaultBlackHole(70.0f).addOrbitingObject((OrbitingCelestialObject)CAVUM_TENBRAE, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
        private static final Galaxy.SpiralGalaxy MILKY_WAY = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(100.0f, 10842L, 4, 1500).addGalacticObject((StellarObject)new Supernova(10.0f, 378000L, 120000L), 10.0f, -3.0f, 2.0f).addGalacticObject((StellarObject)P3W_451_BLACK_HOLE, 3.0f, 3.0f, 3.0f, 0.0f, 0.9424778f, 2.5132742f);

        public StellarViewCavumTenebraeEffects() {
            super(new StellarViewSky((OrbitingCelestialObject)CAVUM_TENBRAE), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            MILKY_WAY.setStarBuffer(3.0f, 3.0f, 3.0f, 0.0f, 0.9424778f, 2.5132742f);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (ClientSkyConfig.custom_cavum_tenebrae_sky.get()) {
                super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
            }
            return ClientSkyConfig.custom_cavum_tenebrae_sky.get();
        }
    }

    public static class StellarViewLanteaEffects
    extends StellarViewSpecialEffects {
        private static final Moon LANTEAN_MOON = new Moon.DefaultMoon(25.0f);
        private static final Planet LANTEA = (Planet)new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000).addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setDefaultRarity(10), (MeteorShower)new MeteorShower().setDefaultRarity(10))).addOrbitingObject((OrbitingCelestialObject)LANTEAN_MOON, 384400.0f, 45.0f, (float)Math.toRadians(45.0), (float)Math.toRadians(12.0), 0.0f);
        private static final Sun LANTEAN_SUN = (Sun)new Sun.VanillaSun().addOrbitingObject((OrbitingCelestialObject)LANTEA, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
        private static final Galaxy.SpiralGalaxy PEGASUS = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(100.0f, 17892L, 2, 2250).addGalacticObject((StellarObject)new Supernova(10.0f, 783000L, 72000L), 1.0f, -2.0f, 4.0f).addGalacticObject((StellarObject)new Supernova(10.0f, 1153000L, 144000L), 7.0f, 3.0f, 0.0f).addGalacticObject((StellarObject)LANTEAN_SUN, 8.0f, 0.0f, 16.0f, 1.0995574f, 1.0995574f, 0.4712389f);

        public StellarViewLanteaEffects() {
            super(new StellarViewSky((OrbitingCelestialObject)LANTEA), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            PEGASUS.setStarBuffer(8.0f, 0.0f, 16.0f, 0.0f, 0.62831855f, 1.8849556f);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (ClientSkyConfig.custom_lantea_sky.get()) {
                super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
            }
            return ClientSkyConfig.custom_lantea_sky.get();
        }
    }

    public static class StellarViewAthosEffects
    extends StellarViewSpecialEffects {
        private static final Moon ATHOS_MOON = new Moon.DefaultMoon(25.0f);
        private static final Planet ATHOS = (Planet)new Planet(Planet.EARTH_TEXTURE, 30.0f, 24000).addAtmosphere(new Planet.Atmosphere((ShootingStar)new ShootingStar().setDefaultRarity(10), (MeteorShower)new MeteorShower().setDefaultRarity(10))).addOrbitingObject((OrbitingCelestialObject)ATHOS_MOON, 384400.0f, 45.0f, (float)Math.toRadians(45.0), (float)Math.toRadians(12.0), 0.0f);
        private static final Sun ATHOS_SUN = (Sun)new Sun.VanillaSun().addOrbitingObject((OrbitingCelestialObject)ATHOS, 1.4728E8f, 3.75f, 0.0f, 0.0f, 0.0f);
        private static final Galaxy.SpiralGalaxy PEGASUS = (Galaxy.SpiralGalaxy)new Galaxy.SpiralGalaxy(100.0f, 17892L, 2, 2250).addGalacticObject((StellarObject)new Supernova(10.0f, 783000L, 72000L), 1.0f, -2.0f, 4.0f).addGalacticObject((StellarObject)new Supernova(10.0f, 1153000L, 144000L), 7.0f, 3.0f, 0.0f).addGalacticObject((StellarObject)ATHOS_SUN, 7.0f, 5.0f, 14.0f, 1.0995574f, 1.0995574f, 0.4712389f);

        public StellarViewAthosEffects() {
            super(new StellarViewSky((OrbitingCelestialObject)ATHOS), 192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            PEGASUS.setStarBuffer(7.0f, 5.0f, 14.0f, 1.5707964f, 0.43982297f, 3.7699113f);
        }

        public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
            if (ClientSkyConfig.custom_athos_sky.get()) {
                super.renderSky(level, ticks, partialTick, poseStack, camera, projectionMatrix, isFoggy, setupFog);
            }
            return ClientSkyConfig.custom_athos_sky.get();
        }
    }
}

