/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.povstalec.sgjourney.client.render.FluidTankRenderer;
import net.povstalec.sgjourney.common.menu.NaquadahLiquidizerMenu;

public class NaquadahLiquidizerScreen
extends AbstractContainerScreen<NaquadahLiquidizerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("sgjourney", "textures/gui/naquadah_liquidizer_gui.png");
    private FluidTankRenderer renderer;

    public NaquadahLiquidizerScreen(NaquadahLiquidizerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    public void m_7856_() {
        super.m_7856_();
        this.assignFluidRenderer();
    }

    private void assignFluidRenderer() {
        this.renderer = new FluidTankRenderer(4000L, true, 16, 54);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.renderProgress(graphics, x + 28, y + 37);
        this.renderer.render(graphics, x + 12, y + 20, ((NaquadahLiquidizerMenu)this.f_97732_).getFluid1());
        this.renderer.render(graphics, x + 148, y + 20, ((NaquadahLiquidizerMenu)this.f_97732_).getFluid2());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        this.liquidFluid1Tooltip(graphics, 12, 20, mouseX, mouseY);
        this.liquidFluid2Tooltip(graphics, 148, 20, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    protected void renderProgress(GuiGraphics graphics, int x, int y) {
        float percentage = (float)((NaquadahLiquidizerMenu)this.f_97732_).getProgress() / 100.0f;
        int actual = Math.round(119.0f * percentage);
        graphics.m_280218_(TEXTURE, x, y, 0, 166, actual, 12);
    }

    protected void liquidFluid1Tooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.m_6774_(x, y, 16, 54, mouseX, mouseY)) {
            FluidStack fluidStack = new FluidStack(((NaquadahLiquidizerMenu)this.f_97732_).getDesiredFluid1(), 1);
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)fluidStack.getTranslationKey()).m_7220_((Component)Component.m_237113_((String)(": " + ((NaquadahLiquidizerMenu)this.f_97732_).getFluid1().getAmount() + "/4000mB"))).m_130940_(ChatFormatting.GREEN), mouseX, mouseY);
        }
    }

    protected void liquidFluid2Tooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        if (this.m_6774_(x, y, 16, 54, mouseX, mouseY)) {
            FluidStack fluidStack = new FluidStack(((NaquadahLiquidizerMenu)this.f_97732_).getDesiredFluid2(), 1);
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)fluidStack.getTranslationKey()).m_7220_((Component)Component.m_237113_((String)(": " + ((NaquadahLiquidizerMenu)this.f_97732_).getFluid2().getAmount() + "/4000mB"))).m_130940_(ChatFormatting.GREEN), mouseX, mouseY);
        }
    }
}

