/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.client.sound.StargateSoundWrapper;
import net.povstalec.sgjourney.client.sound.sounds.GenericStargateSound;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.stargate.StargateVariant;

public class SoundAccess {
    public static final String EMPTY = "sgjourney:empty";
    protected static Minecraft minecraft = Minecraft.m_91087_();

    public static void playWormholeOpenSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeOpenSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playWormholeIdleSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.wormholeIdleSound == null || !stargate.wormholeIdleSound.hasSound()) {
                stargate.wormholeIdleSound = new StargateSoundWrapper.WormholeIdle(stargate);
            }
            stargate.playWormholeIdleSound();
        }
    }

    public static void playWormholeCloseSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getWormholeCloseSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void playChevronSound(BlockPos pos, boolean isPrimary, boolean incoming, boolean open, boolean encode) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof AbstractStargateEntity)) return;
        AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
        if (stargate instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
            if (open || encode) {
                if (open) {
                    GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronOpenSound(milkyWayStargate, isPrimary), 0.5f);
                    minecraft.m_91106_().m_120367_((SoundInstance)sound);
                    return;
                }
                if (!encode) return;
                GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEncodeSound(milkyWayStargate), 0.5f);
                minecraft.m_91106_().m_120367_((SoundInstance)sound);
                return;
            }
        }
        if (incoming) {
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronIncomingSound(stargate, isPrimary), 0.5f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
            return;
        }
        GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getChevronEngageSound(stargate, isPrimary), 0.5f);
        minecraft.m_91106_().m_120367_((SoundInstance)sound);
    }

    public static void playFailSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getFailSound(stargate), 0.5f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playRotationSound(BlockPos pos, boolean stop) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            if (stargate.spinSound == null) {
                if (stargate instanceof UniverseStargateEntity) {
                    UniverseStargateEntity universeStargate = (UniverseStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.UniverseRingRotation(universeStargate);
                } else if (stargate instanceof MilkyWayStargateEntity) {
                    MilkyWayStargateEntity milkyWayStargate = (MilkyWayStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.MilkyWayRingRotation(milkyWayStargate);
                } else if (stargate instanceof PegasusStargateEntity) {
                    PegasusStargateEntity pegasusStargate = (PegasusStargateEntity)stargate;
                    stargate.spinSound = new StargateSoundWrapper.PegasusRingRotation(pegasusStargate);
                }
            }
            if (stop) {
                stargate.stopRotationSound();
            } else {
                stargate.playRotationSound();
            }
        }
    }

    public static void playUniverseStartSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof UniverseStargateEntity) {
            UniverseStargateEntity stargate = (UniverseStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getStartupSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static void playMilkyWayBuildupSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            if (stargate.buildupSound == null || !stargate.buildupSound.hasSound()) {
                stargate.buildupSound = new StargateSoundWrapper.MilkyWayRingBuildup(stargate);
            }
            stargate.playBuildupSound();
        }
    }

    public static void playMilkyWayStopSound(BlockPos pos) {
        BlockEntity blockEntity = SoundAccess.minecraft.f_91073_.m_7702_(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            GenericStargateSound sound = new GenericStargateSound(stargate, SoundAccess.getRotationStopSound(stargate), 0.75f);
            minecraft.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    private static Optional<StargateVariant> getVariant(String variantString) {
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry variantRegistry = registries.m_175515_(StargateVariant.REGISTRY_KEY);
        Optional<StargateVariant> variant = Optional.ofNullable((StargateVariant)variantRegistry.m_7745_(new ResourceLocation(variantString)));
        return variant;
    }

    private static SoundEvent getChevronEngageSound(AbstractStargateEntity stargate, boolean isPrimary) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent()) {
            StargateVariant stargateVariant = variant.get();
            if (isPrimary && stargateVariant.getPrimaryChevronEngageSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getPrimaryChevronEngageSound().get());
            }
            if (stargateVariant.getChevronEngageSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getChevronEngageSound().get());
            }
        }
        return stargate.getChevronEngageSound();
    }

    private static SoundEvent getChevronOpenSound(MilkyWayStargateEntity stargate, boolean isPrimary) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent()) {
            StargateVariant stargateVariant = variant.get();
            if (isPrimary && stargateVariant.getPrimaryChevronOpenSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getPrimaryChevronOpenSound().get());
            }
            if (stargateVariant.getChevronOpenSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getChevronOpenSound().get());
            }
        }
        return stargate.getChevronOpenSound();
    }

    public static SoundEvent getStartupSound(UniverseStargateEntity stargate) {
        StargateVariant stargateVariant;
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && (stargateVariant = variant.get()).getStartupSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getStartupSound().get());
        }
        return stargate.getStartupSound();
    }

    public static SoundEvent getRotationSound(AbstractStargateEntity stargate) {
        StargateVariant stargateVariant;
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && (stargateVariant = variant.get()).getRotationSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getRotationSound().get());
        }
        return stargate.getRotationSound();
    }

    public static SoundEvent getRotationBuildupSound(MilkyWayStargateEntity stargate) {
        StargateVariant stargateVariant;
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && (stargateVariant = variant.get()).getRotationBuildupSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getRotationBuildupSound().get());
        }
        return stargate.getRingRotationBuildupSound();
    }

    public static SoundEvent getRotationStopSound(MilkyWayStargateEntity stargate) {
        StargateVariant stargateVariant;
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && (stargateVariant = variant.get()).getRotationStopSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getRotationStopSound().get());
        }
        return stargate.getRingRotationStopSound();
    }

    private static SoundEvent getChevronEncodeSound(MilkyWayStargateEntity stargate) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && variant.get().getChevronEncodeSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)variant.get().getChevronEncodeSound().get());
        }
        return stargate.getChevronEncodeSound();
    }

    private static SoundEvent getChevronIncomingSound(AbstractStargateEntity stargate, boolean isPrimary) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent()) {
            StargateVariant stargateVariant = variant.get();
            if (isPrimary && stargateVariant.getPrimaryChevronIncomingSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getPrimaryChevronIncomingSound().get());
            }
            if (stargateVariant.getChevronIncomingSound().isPresent()) {
                return SoundEvent.m_262824_((ResourceLocation)stargateVariant.getChevronIncomingSound().get());
            }
        }
        return stargate.getChevronIncomingSound();
    }

    private static SoundEvent getFailSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && variant.get().getFailSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)variant.get().getFailSound().get());
        }
        return stargate.getFailSound();
    }

    private static SoundEvent getWormholeOpenSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && variant.get().getWormholeOpenSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)variant.get().getWormholeOpenSound().get());
        }
        return stargate.getWormholeOpenSound();
    }

    public static SoundEvent getWormholeIdleSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && variant.get().getWormholeIdleSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)variant.get().getWormholeIdleSound().get());
        }
        return stargate.getWormholeIdleSound();
    }

    private static SoundEvent getWormholeCloseSound(AbstractStargateEntity stargate) {
        Optional<StargateVariant> variant;
        String variantString;
        if (ClientStargateConfig.stargate_variants.get() && !(variantString = stargate.getVariant()).equals(EMPTY) && (variant = SoundAccess.getVariant(variantString)).isPresent() && variant.get().getWormholeCloseSound().isPresent()) {
            return SoundEvent.m_262824_((ResourceLocation)variant.get().getWormholeCloseSound().get());
        }
        return stargate.getWormholeCloseSound();
    }
}

