/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.packets.ClientboundNaquadahGeneratorUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class NaquadahGeneratorEntity
extends EnergyBlockEntity {
    private int reactionProgress = 0;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public NaquadahGeneratorEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, true);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public boolean hasNaquadah() {
        return this.itemHandler.getStackInSlot(0).m_41720_() == ItemInit.NAQUADAH.get();
    }

    public void setReactionProgress(int reactionProgress) {
        this.reactionProgress = reactionProgress;
    }

    public int getReactionProgress() {
        return this.reactionProgress;
    }

    public abstract int getReactionTime();

    public abstract int getEnergyPerTick();

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                NaquadahGeneratorEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ItemInit.NAQUADAH.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 16;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected boolean receivesEnergy() {
        return false;
    }

    private void doReaction() {
        if (this.hasNaquadah() && this.reactionProgress == 0) {
            this.itemHandler.extractItem(0, 1, false);
            this.progressReaction();
        } else if (this.reactionProgress > 0 && this.reactionProgress < this.getReactionTime() && this.getEnergyStored() < this.capacity()) {
            this.progressReaction();
        } else if (this.reactionProgress >= this.getReactionTime()) {
            this.reactionProgress = 0;
        }
    }

    private void progressReaction() {
        this.generateEnergy(this.getEnergyPerTick());
        ++this.reactionProgress;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NaquadahGeneratorEntity generator) {
        if (level.f_46443_) {
            return;
        }
        generator.doReaction();
        generator.outputEnergy(Direction.DOWN);
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(generator.f_58858_)), (Object)new ClientboundNaquadahGeneratorUpdatePacket(generator.f_58858_, generator.getReactionProgress(), generator.getEnergyStored()));
    }
}

