/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class ClassicStargateEntity
extends AbstractStargateEntity {
    public static final float CLASSIC_THICKNESS = 8.0f;
    public static final float HORIZONTAL_CENTER_CLASSIC_HEIGHT = 0.25f;
    private static final short ROTATION_TICK_DURATION = 40;
    private static final short CHEVRON_LOCK_TICK_DURATION = 20;
    private short rotationOld = 0;
    private short rotation = 0;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;

    public ClassicStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), pos, state, Stargate.Gen.NONE, 0, 0.5f, 0.25f);
        this.displayID = true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isPointOfOriginValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("PoO is not valid " + this.pointOfOrigin);
            this.setPointOfOrigin(this.m_58904_());
        }
        if (!this.areSymbolsValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("Symbols are not valid " + this.symbols);
            this.setSymbols(this.m_58904_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
        this.symbols = tag.m_128461_("Symbols");
        if (tag.m_128441_("Rotation")) {
            this.rotation = tag.m_128448_("Rotation");
        }
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
        tag.m_128359_("Symbols", this.symbols);
        tag.m_128376_("Rotation", this.rotation);
    }

    @Override
    public CompoundTag serializeStargateInfo() {
        CompoundTag tag = super.serializeStargateInfo();
        tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
        tag.m_128359_("Symbols", this.symbols);
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        if (tag.m_128441_("PointOfOrigin")) {
            this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
        }
        if (tag.m_128441_("Symbols")) {
            this.pointOfOrigin = tag.m_128461_("Symbols");
        }
        this.symbols = tag.m_128461_("Symbols");
        super.deserializeStargateInfo(tag, isUpgraded);
    }

    @Override
    public void setPointOfOrigin(Level level) {
        Random random = new Random();
        this.pointOfOrigin = PointOfOrigin.getRandomPointOfOrigin(level.m_7654_(), random.nextLong()).m_135782_().toString();
        this.m_6596_();
    }

    @Override
    public SoundEvent getRotationSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_RING_SPIN.get();
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.CLASSIC_CHEVRON_ENGAGE.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.CLASSIC_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getWormholeCloseSound() {
        return (SoundEvent)SoundInit.CLASSIC_WORMHOLE_CLOSE.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.CLASSIC_DIAL_FAIL.get();
    }

    public double angle() {
        return 10.0;
    }

    public short getRotation() {
        return this.rotation;
    }

    public void setRotation(short rotation) {
        this.rotation = rotation;
    }

    public int getCurrentSymbol() {
        int currentSymbol;
        double position = (double)(this.rotation * 2) / this.angle();
        if (position >= (double)(currentSymbol = (int)position) + 0.5) {
            ++currentSymbol;
        }
        if (currentSymbol > 38) {
            currentSymbol -= 39;
        }
        return currentSymbol;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ClassicStargateEntity stargate) {
        stargate.handleRotation();
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    private void handleRotation() {
        this.rotationOld = this.rotation;
    }

    private void rotate() {
        this.rotation = (short)(this.rotation + 4);
    }

    public float getRotation(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.rotationOld, (float)this.rotation);
    }

    @Override
    public void playRotationSound() {
    }

    @Override
    public void stopRotationSound() {
    }

    @Override
    public Stargate.ChevronLockSpeed getChevronLockSpeed() {
        return (Stargate.ChevronLockSpeed)((Object)CommonStargateConfig.classic_chevron_lock_speed.get());
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerClassicStargateMethods(wrapper);
    }
}

