/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.sound.SoundWrapper;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.packets.ClientBoundSoundPackets;
import net.povstalec.sgjourney.common.packets.ClientboundMilkyWayStargateUpdatePacket;
import net.povstalec.sgjourney.common.stargate.Stargate;
import org.jetbrains.annotations.NotNull;

public class MilkyWayStargateEntity
extends AbstractStargateEntity {
    public static final int MAX_ROTATION = 312;
    private int rotation = 0;
    public int oldRotation = 0;
    public boolean isChevronOpen = false;
    private Map<StargatePart, Integer> signalMap = Maps.newHashMap();
    public int signalStrength = 0;
    public boolean computerRotation = false;
    public int desiredSymbol = 0;
    public boolean rotateClockwise = true;
    public SoundWrapper buildupSound = null;

    public MilkyWayStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get(), pos, state, Stargate.Gen.GEN_2, 2);
    }

    @Override
    public void onLoad() {
        if (!this.f_58857_.m_5776_() && !this.addToNetwork) {
            Random random = new Random();
            this.setRotation(2 * random.nextInt(0, 157));
        }
        super.onLoad();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isPointOfOriginValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("PoO is not valid " + this.pointOfOrigin);
            this.setPointOfOrigin(this.m_58904_());
        }
        if (!this.areSymbolsValid(this.f_58857_)) {
            StargateJourney.LOGGER.info("Symbols are not valid " + this.symbols);
            this.setSymbols(this.m_58904_());
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
        this.symbols = tag.m_128461_("Symbols");
        this.oldRotation = this.rotation = tag.m_128451_("Rotation");
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
        tag.m_128359_("Symbols", this.symbols);
        tag.m_128405_("Rotation", this.rotation);
    }

    @Override
    public CompoundTag serializeStargateInfo() {
        CompoundTag tag = super.serializeStargateInfo();
        tag.m_128359_("PointOfOrigin", this.pointOfOrigin);
        tag.m_128359_("Symbols", this.symbols);
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, boolean isUpgraded) {
        if (tag.m_128441_("PointOfOrigin")) {
            this.pointOfOrigin = tag.m_128461_("PointOfOrigin");
        }
        if (tag.m_128441_("Symbols")) {
            this.symbols = tag.m_128461_("Symbols");
        }
        super.deserializeStargateInfo(tag, isUpgraded);
    }

    public boolean isChevronOpen() {
        return this.isChevronOpen;
    }

    public SoundEvent getRingRotationBuildupSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_RING_SPIN_START.get();
    }

    @Override
    public SoundEvent getRotationSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_RING_SPIN.get();
    }

    public SoundEvent getRingRotationStopSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_RING_SPIN_STOP.get();
    }

    @Override
    public SoundEvent getChevronEngageSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_ENGAGE.get();
    }

    public SoundEvent getChevronOpenSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_OPEN.get();
    }

    public SoundEvent getChevronEncodeSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_CHEVRON_ENCODE.get();
    }

    @Override
    public SoundEvent getWormholeOpenSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_WORMHOLE_OPEN.get();
    }

    @Override
    public SoundEvent getWormholeCloseSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_WORMHOLE_CLOSE.get();
    }

    @Override
    public SoundEvent getFailSound() {
        return (SoundEvent)SoundInit.MILKY_WAY_DIAL_FAIL.get();
    }

    private void manualDialing() {
        if (this.signalStrength > 0 && (this.getCurrentSymbol() != 0 || this.getAddress().getLength() > 0)) {
            if (this.signalStrength == 15) {
                if (!this.isConnected()) {
                    this.openChevron();
                } else {
                    this.disconnectStargate(Stargate.Feedback.CONNECTION_ENDED_BY_POINT_OF_ORIGIN);
                }
            }
        } else {
            this.closeChevron();
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
    }

    private boolean hadBestRedstoneSignalChanged() {
        int previousSignalStrength = this.signalStrength;
        this.signalStrength = 0;
        this.signalMap.forEach((stargatePart, signal) -> {
            if (signal > this.signalStrength) {
                this.signalStrength = signal;
            }
        });
        return previousSignalStrength != this.signalStrength;
    }

    public void updateSignal(StargatePart part, int signal) {
        if (!((Boolean)CommonStargateConfig.enable_redstone_dialing.get()).booleanValue()) {
            return;
        }
        if (this.signalMap.containsKey((Object)part)) {
            this.signalMap.remove((Object)part);
        }
        this.signalMap.put(part, signal);
        if (this.hadBestRedstoneSignalChanged()) {
            this.manualDialing();
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getRotation(float partialTick) {
        return StargateJourneyConfig.disable_smooth_animations.get() ? (float)this.getRotation() : Mth.m_14179_((float)partialTick, (float)this.oldRotation, (float)this.rotation);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public boolean isRotating() {
        return this.rotation != this.oldRotation;
    }

    public Stargate.Feedback openChevron() {
        if (!this.isChevronOpen && !this.getAddress().containsSymbol(this.getCurrentSymbol())) {
            if (!this.f_58857_.m_5776_()) {
                PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.Chevron(this.f_58858_, this.getCurrentSymbol() == 0, false, true, false));
            }
            this.isChevronOpen = true;
            if (!this.f_58857_.m_5776_()) {
                this.synchronizeWithClient(this.f_58857_);
            }
            return Stargate.Feedback.CHEVRON_RAISED;
        }
        return this.setRecentFeedback(Stargate.Feedback.CHEVRON_ALREADY_RAISED);
    }

    public Stargate.Feedback encodeChevron() {
        int symbol;
        if (!this.isChevronOpen) {
            return this.setRecentFeedback(Stargate.Feedback.CHEVRON_NOT_RAISED);
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
        if ((symbol = this.getCurrentSymbol()) == 0) {
            return this.setRecentFeedback(Stargate.Feedback.CANNOT_ENCODE_POINT_OF_ORIGIN);
        }
        return this.setRecentFeedback(this.encodeChevron(symbol, false, true));
    }

    public Stargate.Feedback closeChevron() {
        if (this.isChevronOpen) {
            this.isChevronOpen = false;
            Stargate.Feedback feedback = this.engageSymbol(this.getCurrentSymbol());
            if (feedback == Stargate.Feedback.SYMBOL_IN_ADDRESS) {
                this.chevronSound(this.getCurrentSymbol() == 0, false, false, false);
            }
            return this.setRecentFeedback(feedback);
        }
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
        return this.setRecentFeedback(Stargate.Feedback.CHEVRON_ALREADY_LOWERED);
    }

    public int getCurrentSymbol() {
        int symbolPosition = this.rotation + 4;
        int currentSymbol = symbolPosition / 8 % 39;
        return currentSymbol;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MilkyWayStargateEntity stargate) {
        stargate.rotate();
        if (stargate.isRotating() && !level.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(stargate.f_58858_)), (Object)new ClientBoundSoundPackets.StargateRotation(stargate.f_58858_, false));
        }
        AbstractStargateEntity.tick(level, pos, state, stargate);
    }

    private void rotate() {
        if (!this.isConnected() && !this.isChevronOpen) {
            if (this.computerRotation) {
                if (this.isCurrentSymbol(this.desiredSymbol)) {
                    this.endRotation(false);
                } else {
                    this.rotate(this.rotateClockwise);
                }
            } else if (this.signalStrength > 0 && this.signalStrength < 15) {
                if (this.signalStrength > 7) {
                    this.rotate(false);
                } else {
                    this.rotate(true);
                }
            } else {
                this.syncRotation();
            }
        } else {
            this.syncRotation();
        }
        this.m_6596_();
    }

    public void rotate(boolean clockwise) {
        this.oldRotation = this.rotation;
        this.rotation = clockwise ? (this.rotation -= 2) : (this.rotation += 2);
        if (this.rotation >= 312) {
            this.rotation -= 312;
            this.oldRotation -= 312;
        } else if (this.rotation < 0) {
            this.rotation += 312;
            this.oldRotation += 312;
        }
        this.m_6596_();
    }

    public boolean isCurrentSymbol(int desiredSymbol) {
        return desiredSymbol * 8 == this.rotation;
    }

    private void synchronizeWithClient(Level level) {
        if (level.m_5776_()) {
            return;
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(this.f_58858_)), (Object)new ClientboundMilkyWayStargateUpdatePacket(this.f_58858_, this.rotation, this.oldRotation, this.isChevronOpen, this.signalStrength, this.computerRotation, this.rotateClockwise, this.desiredSymbol));
    }

    private void syncRotation() {
        this.oldRotation = this.rotation;
        if (!this.f_58857_.m_5776_()) {
            this.synchronizeWithClient(this.f_58857_);
        }
    }

    public Stargate.Feedback startRotation(int desiredSymbol, boolean rotateClockwise) {
        if (this.isChevronOpen) {
            return Stargate.Feedback.ROTATION_BLOCKED;
        }
        this.computerRotation = true;
        this.desiredSymbol = desiredSymbol;
        this.rotateClockwise = rotateClockwise;
        if (!this.f_58857_.m_5776_()) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.MilkyWayBuildup(this.f_58858_));
        }
        this.synchronizeWithClient(this.f_58857_);
        return Stargate.Feedback.ROTATING;
    }

    public Stargate.Feedback endRotation(boolean playSound) {
        if (!this.f_58857_.m_5776_() && playSound) {
            PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientBoundSoundPackets.MilkyWayStop(this.f_58858_));
        }
        if (!this.computerRotation) {
            return Stargate.Feedback.NOT_ROTATING;
        }
        this.computerRotation = false;
        this.synchronizeWithClient(this.f_58857_);
        return Stargate.Feedback.ROTATION_STOPPED;
    }

    public void playBuildupSound() {
        if (this.buildupSound.isPlaying()) {
            this.buildupSound.stopSound();
        }
        this.buildupSound.playSound();
    }

    @Override
    public void playRotationSound() {
        if (!this.spinSound.isPlaying()) {
            this.spinSound.stopSound();
            this.spinSound.playSound();
        }
    }

    @Override
    public void stopRotationSound() {
    }

    @Override
    public Stargate.ChevronLockSpeed getChevronLockSpeed() {
        return (Stargate.ChevronLockSpeed)((Object)CommonStargateConfig.milky_way_chevron_lock_speed.get());
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerMilkyWayStargateMethods(wrapper);
    }
}

