/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Symbols;

public class MilkyWayStargateBlock
extends AbstractStargateBaseBlock {
    public MilkyWayStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 7.0, 1.0);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        MilkyWayStargateEntity stargate = new MilkyWayStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)((Object)BlockInit.MILKY_WAY_RING.get());
    }

    @Override
    public BlockState ringState() {
        return this.getRing().m_49966_();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return MilkyWayStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get(), MilkyWayStargateEntity::tick);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        if (level.m_5776_()) {
            return;
        }
        boolean hasSignal = level.m_276867_(pos) || level.m_276867_(pos.m_7494_());
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockentity;
            if (hasSignal) {
                stargate.updateSignal(StargatePart.BASE, level.m_277086_(pos));
            } else {
                stargate.updateSignal(StargatePart.BASE, 0);
            }
        }
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        Registry pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY);
        Registry symbolsRegistry = registries.m_175515_(Symbols.REGISTRY_KEY);
        String pointOfOrigin = "";
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("PointOfOrigin")) {
            ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("PointOfOrigin"));
            pointOfOrigin = location.toString().equals("sgjourney:empty") ? "Empty" : (pointOfOriginRegistry.m_7804_(location) ? ((PointOfOrigin)pointOfOriginRegistry.m_7745_(location)).getName() : "Error");
        }
        String symbols = "";
        if (stack.m_41782_() && stack.m_41783_().m_128469_("BlockEntityTag").m_128441_("Symbols")) {
            ResourceLocation location = new ResourceLocation(stack.m_41783_().m_128469_("BlockEntityTag").m_128461_("Symbols"));
            symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.m_7804_(location) ? ((Symbols)symbolsRegistry.m_7745_(location)).getName(!ClientStargateConfig.unique_symbols.get()) : "Error");
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)pointOfOrigin)).m_130940_(ChatFormatting.DARK_PURPLE));
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)symbols)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }
}

