/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.ClientSkyConfig;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.config.CommonGeneticConfig;
import net.povstalec.sgjourney.common.config.CommonInterfaceConfig;
import net.povstalec.sgjourney.common.config.CommonNaquadahGeneratorConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateNetworkConfig;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.config.SGJourneyConfigValue;

@Mod.EventBusSubscriber
public class StargateJourneyConfig {
    private static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_CONFIG;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static SGJourneyConfigValue.BooleanValue disable_energy_use;
    public static SGJourneyConfigValue.BooleanValue disable_smooth_animations;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        StargateJourney.LOGGER.info("Loading Config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        StargateJourney.LOGGER.info("Built config: " + path);
        file.load();
        StargateJourney.LOGGER.info("Loaded Config: " + path);
        config.setConfig((CommentedConfig)file);
    }

    private static void generalServerConfig(ForgeConfigSpec.Builder server) {
        server.comment("Stargate Journey General Config");
        disable_energy_use = new SGJourneyConfigValue.BooleanValue(server, "server.disable_energy_requirements", true, "Disable energy requirements for blocks added by Stargate Journey");
    }

    private static void generalClientConfig(ForgeConfigSpec.Builder client) {
        client.comment("Stargate Journey Client Config");
        disable_smooth_animations = new SGJourneyConfigValue.BooleanValue(client, "client.disable_smooth_animations", false, "Disables smooth animations of Stargate Journey Block Entities");
    }

    static {
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.push("Stargate Journey Common Config");
        StargateJourneyConfig.generalServerConfig(COMMON_BUILDER);
        COMMON_BUILDER.push("ZPM Config");
        CommonZPMConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Interface Config");
        CommonInterfaceConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Stargate Config");
        CommonStargateConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Naquadah Generator Config");
        CommonNaquadahGeneratorConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Stargate Network Config");
        CommonStargateNetworkConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Generation Config");
        CommonGenerationConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Tech Config");
        CommonTechConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Genetic Config");
        CommonGeneticConfig.init(COMMON_BUILDER);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_BUILDER.push("Stargate Journey Client Config");
        StargateJourneyConfig.generalClientConfig(CLIENT_BUILDER);
        CLIENT_BUILDER.push("Stargate Config");
        ClientStargateConfig.init(CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("Sky Config");
        ClientSkyConfig.init(CLIENT_BUILDER);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

