/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.init;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.SoundInit;

public enum ArmorMaterialInit implements ArmorMaterial
{
    naquadah("naquadah", 42, new int[]{3, 6, 8, 3}, 5, (Item)ItemInit.NAQUADAH.get(), (SoundEvent)SoundInit.EQUIP_NAQUADAH_ARMOR.get(), 3.0f, 0.2f),
    jaffa("jaffa", 42, new int[]{3, 6, 8, 3}, 5, (Item)ItemInit.NAQUADAH_ALLOY.get(), (SoundEvent)SoundInit.EQUIP_NAQUADAH_ARMOR.get(), 2.0f, 0.0f),
    personal_shield("personal_shield", 0, new int[]{0, 0, 0, 0}, 0, (Item)ItemInit.NAQUADAH.get(), (SoundEvent)SoundInit.EQUIP_NAQUADAH_ARMOR.get(), 0.0f, 0.0f);

    private static final int[] max_damage_array;
    private String name;
    private SoundEvent equipSound;
    private int durability;
    private int enchantability;
    private Item repairItem;
    private int[] damageReductionAmounts;
    private float toughness;
    private float knockbackResistance;

    private ArmorMaterialInit(String name, int durability, int[] damageReductionAmounts, int enchantability, Item repairItem, SoundEvent equipSound, float toughness, float knockbackResistance) {
        this.name = name;
        this.equipSound = equipSound;
        this.durability = durability;
        this.enchantability = enchantability;
        this.repairItem = repairItem;
        this.damageReductionAmounts = damageReductionAmounts;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
    }

    public String m_6082_() {
        return "sgjourney:" + this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    public int m_266425_(ArmorItem.Type type) {
        return max_damage_array[type.m_266308_().m_20749_()] * this.durability;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmounts[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.repairItem});
    }

    static {
        max_damage_array = new int[]{13, 15, 16, 11};
    }
}

