/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import org.jetbrains.annotations.Nullable;

public class StargateVariantItem
extends Item {
    public static final String VARIANT = "Variant";

    public StargateVariantItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack stack) {
        return stack.m_41782_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (stack.m_41782_() && stack.m_41784_().m_128441_(VARIANT)) {
            String variant = stack.m_41784_().m_128461_(VARIANT);
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.variant").m_7220_((Component)Component.m_237113_((String)(": " + variant))).m_130940_(ChatFormatting.GREEN));
        }
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.stargate_variant.description").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static Optional<String> getVariantString(ItemStack stack) {
        Optional<String> variant = Optional.empty();
        if (stack.m_41720_() instanceof StargateVariantItem && stack.m_41784_().m_128441_(VARIANT)) {
            String variantString = stack.m_41783_().m_128461_(VARIANT);
            variant = Optional.of(variantString);
        }
        return variant;
    }

    public static <StargateBlock extends AbstractStargateBlock> ItemStack stargateVariant(String variant) {
        ItemStack stack = new ItemStack((ItemLike)ItemInit.STARGATE_VARIANT_CRYSTAL.get());
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128359_(VARIANT, variant);
        stack.m_41751_(compoundtag);
        return stack;
    }
}

